/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.auth;


import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Elan
 */
@Entity
@Table(name = "Service_Audit")
@NamedQueries({

               @NamedQuery(name = "ServiceAudit.findServiceAuditByCN", query = "SELECT c FROM ServiceAudit c WHERE c.cn = :cn order by c.eventDate desc"),
               @NamedQuery(name = "ServiceAudit.findServiceAuditByWebService", query = "SELECT c FROM ServiceAudit c WHERE c.webService = :webService order by c.eventDate desc"),
               @NamedQuery(name = "ServiceAudit.findDistinctWebServices", query = "SELECT DISTINCT c.webService FROM ServiceAudit c ORDER BY c.webService" ),
               @NamedQuery(name = "ServiceAudit.findDistinctCallByWebService", query = "SELECT DISTINCT c.call FROM ServiceAudit c WHERE c.webService = :webService ORDER BY c.call" )
})
public class ServiceAudit  implements Serializable {
    @Id
    @SequenceGenerator(name = "ServiceAuditSequence", sequenceName = "Service_Audit_SEQ", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "ServiceAuditSequence")
    @Basic(optional = false)
    @Column(name = "ID")
    private Long ID;
    @Basic(optional = false)
    @Column(name = "WEB_SERVICE")
    private String webService;
    @Basic(optional = false)
    @Column(name = "call")
    private String call;
    @Basic(optional = false)
    @Column(name = "EVENT_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date eventDate;
    @Basic(optional = false)
    @Column(name = "ip")
    private String ip;
    @Basic(optional = false)
    @Column(name = "cn")
    private String cn;
    @Basic(optional = false)
    @Column(name = "authorized")
    private int authorized;
    @Basic(optional = true)
    @Column(name = "SUCCESS")
    private Integer success;
    @Basic(optional = true)
    @Column(name = "DURATION")
    private Integer duration; //stored as milliseconds

    public Long getID() {
        return ID;
    }

    public void setID(Long ID) {
        this.ID = ID;
    }

    public String getWebService() {
        return webService;
    }

    public void setWebService(String service) {
        this.webService = service;
    }

    public String getCall() {
        return call;
    }

    public void setCall(String call) {
        this.call = call;
    }

    public Date getEventDate() {
        return eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCN() {
        return cn;
    }

    public void setCN(String  cn) {
        this.cn = cn;
    }
    
    public boolean getAuthorized() {
        return authorized==1;
    }

    public void setAuthorized(boolean auth) {
        this.authorized = (auth)?1:0;
    }
    
    public Integer getSuccess() {
        return success;
    }

    public void setSuccess(Integer success) {
        this.success = success;
    }
    
    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }
}
