package gov.va.nvap.service.audit.data;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "USER_ACCESS_AUDIT")
@NamedQueries({
    @NamedQuery(name = "UserAccessAudit.hourCount", query = "SELECT COUNT(u) FROM UserAccessAudit u WHERE u.timeOfEvent BETWEEN :startDate AND :endDate")})
public class UserAccessAudit implements Serializable {
	/**
	 *
	 */
	private static final long serialVersionUID = -1215219925182629651L;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	@Column(name = "TIME_OF_EVENT")
	@Temporal(TemporalType.TIMESTAMP)
	private Date timeOfEvent;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "USER_ACCESS_AUDIT_ID")
	private Long userAccessAuditId;
	@Column(name = "USER_FACILITY")
	private String userFacility;
	@Column(name = "USER_ID")
	private String userId;

	public UserAccessAudit() {
	}

	public UserAccessAudit(final String userId, final String userFacility,
			final Date timeOfEvent, final Date createdDate) {
		this.userFacility = userFacility;
		this.userId = userId;
		this.timeOfEvent = timeOfEvent;
		this.createdDate = createdDate;
	}

	/**
	 * @return the createdDate
	 */
	public Date getCreatedDate() {
		return this.createdDate;
	}

	/**
	 * @return the timeOfEvent
	 */
	public Date getTimeOfEvent() {
		return this.timeOfEvent;
	}

	/**
	 * @return the userAccessAuditId
	 */
	public Long getUserAccessAuditId() {
		return this.userAccessAuditId;
	}

	/**
	 * @return the userFacility
	 */
	public String getUserFacility() {
		return this.userFacility;
	}

	public String getUserId() {
		return this.userId;
	}

	/**
	 * @param createdDate
	 *            the createdDate to set
	 */
	public void setCreatedDate(final Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * @param timeOfEvent
	 *            the timeOfEvent to set
	 */
	public void setTimeOfEvent(final Date timeOfEvent) {
		this.timeOfEvent = timeOfEvent;
	}

	/**
	 * @param userAccessAuditId
	 *            the userAccessAuditId to set
	 */
	public void setUserAccessAuditId(final Long userAccessAuditId) {
		this.userAccessAuditId = userAccessAuditId;
	}

	/**
	 * @param userFacility
	 *            the userFacility to set
	 */
	public void setUserFacility(final String userFacility) {
		this.userFacility = userFacility;
	}

	public void setUserId(final String userId) {
		this.userId = userId;
	}

	@Override
	public String toString() {
		return (new StringBuilder())
				.append("gov.va.nvap.service.audit.data.UserAccessAudit[userAccessAuditId=")
				.append(this.userAccessAuditId).append("]").toString();
	}
}
