package gov.va.nvap.service.adapter.audit;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
import gov.va.med.nhin.adapter.audit.AuditSummariesType;
import gov.va.med.nhin.adapter.audit.AuditSummaryType;
import gov.va.med.nhin.adapter.audit.AuditType;
import gov.va.med.nhin.adapter.audit.AuditsType;
import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.GetAuditsSummary;
import gov.va.med.nhin.adapter.audit.GetAuditsSummaryResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.med.nhin.adapter.audit.SortDirection;
import gov.va.med.nhin.adapter.audit.SortFieldsType;
import gov.va.med.nhin.adapter.audit.SummaryFieldsType;

import gov.va.nvap.service.adapter.audit.DirectAuditManager;
import gov.va.nvap.service.audit.AuditException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import javax.xml.XMLConstants;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import weblogic.net.http.HttpsURLConnection;
import gov.va.nvap.common.util.DocumentBuilderFactoryUtil;
import java.io.ByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import static org.apache.commons.lang.StringEscapeUtils.escapeXml;

/**
 *
 * @author 564685
 */
public class DirectServiceEndpoint implements DirectAuditManager
{

    Properties props;

    public DirectServiceEndpoint()
    {
        props = new Properties();
        InputStream stream = DirectServiceEndpoint.class.getResourceAsStream("/META-INF/direct.properties");
        try {
            props.load(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("\nFailed : Unable to load direct properties");
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {

            }
        }

    }

    private String createSearchString(HashMap<String, String> search)
    {
        String search_url = "";
        for (Entry<String, String> entry : search.entrySet()) {
            try {
                if (search_url.equals("")) {
                    search_url += "?" + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
                }
                else {
                    search_url += "&" + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(DirectServiceEndpoint.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return search_url;
    }

    private Document getDoc(String search_url) throws DirectServiceException
    {
        HttpURLConnection conn = null;
        Document doc = null;
        try {
            URL url = new URL((String) props.get("direct.url") + search_url);

            conn = (HttpURLConnection) url.openConnection();
            Date dt = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "GET\n" + dstr + "\n" + search_url;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(((String) props.get("direct.privatekey")).getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + ((String) props.get("direct.publickey")) + ":" + encsha;
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            String charset = "UTF-8";

            // Allow Inputs
            conn.setDoInput(true);

            // Allow Outputs
            conn.setDoOutput(true);

            // Don't use a cached copy.
            conn.setUseCaches(false);

            // Use a GET method.
            conn.setRequestMethod("GET");

            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Accept-Charset", charset);
            conn.setRequestProperty("Charset", charset);
            conn.setRequestProperty("Cache-Control", "no-cache");

            try {
                conn.connect();
            } catch(Exception e) {
                throw new DirectServiceException();
            }

            //added the response message on failure as well, because it can help with debugging potentially
            /*if (conn.getResponseCode() != 200) {
                throw new AuditException();
                //throw new RuntimeException("\nFailed : HTTP error code : " + conn.getResponseCode() + "\nHTTP response : " + conn.getResponseMessage());
            }*/
            InputStream is = null;
            InputStream newIs = null;
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactoryUtil.getDocumentBuilderFactory(null, true, false, false);

                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                is = conn.getInputStream();

                final String strEscaped = escapeXml(IOUtils.toString(is, "UTF-8"));
                //strEscaped = escapeXml(strEscaped);
                newIs = new ByteArrayInputStream(strEscaped.getBytes("UTF-8"));

                doc = dBuilder.parse(newIs);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException io) {

                    }
                }
                if (newIs != null) {
                    try {
                        newIs.close();
                    }
                    catch (IOException io) {

                    }
                }
            }

        }
        catch (MalformedURLException ex) {
            Logger.getLogger(DirectServiceEndpoint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DirectServiceEndpoint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(DirectServiceEndpoint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidKeyException ex) {
            Logger.getLogger(DirectServiceEndpoint.class.getName()).log(Level.SEVERE, null, ex);
        }
        return doc;

    }

    private AuditsType getAudits(HashMap<String, String> search) throws DirectServiceException
    {
        String search_url = createSearchString(search);

        AuditsType auditsType = new AuditsType();
        Document doc = this.getDoc(((String) props.get("direct.audit")) + search_url);
        try {
            if (doc != null) {
                NodeList nList = doc.getElementsByTagName("item");
                DatatypeFactory df = DatatypeFactory.newInstance();
                for (int temp = 0; temp < nList.getLength(); temp++) {

                    Node nNode = nList.item(temp);

                    if (nNode.getNodeType() == Node.ELEMENT_NODE) {
                        Element eElement = (Element) nNode;
                        AuditType audit = new AuditType();
                        audit.setOrganizationName(eElement.getElementsByTagName("recipient").item(0).getTextContent());
                        audit.setPatientGivenName(eElement.getElementsByTagName("first").item(0).getTextContent());
                        audit.setPatientLastName(eElement.getElementsByTagName("last").item(0).getTextContent());
                        audit.setPatientSSN(eElement.getElementsByTagName("ssn").item(0).getTextContent());
                        audit.setUserId(eElement.getElementsByTagName("username").item(0).getTextContent());
                        Calendar auditTime = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
                        auditTime.setTime(new Date((Long.parseLong(eElement.getElementsByTagName("disclosed").item(0).getTextContent())) * 1000L));
                        audit.setAuditTime(df.newXMLGregorianCalendar((GregorianCalendar) auditTime));
                        audit.setPurposeForUse(eElement.getElementsByTagName("purpose").item(0).getTextContent());
                        audit.setDocumentTitle(eElement.getElementsByTagName("title").item(0).getTextContent());
                        auditsType.getAudit().add(audit);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new DirectServiceException();
            //ex.printStackTrace();
        }
        return auditsType;
    }

    @Override
    public GetAuditsResponse getAudits(GetAudits body) throws DirectServiceException
    {
        GetAuditsResponse ret = new GetAuditsResponse();
        HashMap<String, String> search = new HashMap<String, String>();
        int pageSize = -1, pageNumber = 0;

        if (body.getFromDate() != null) {
            search.put("start", Long.toString(body.getFromDate().toGregorianCalendar().getTimeInMillis() / 1000L));
        }
        if (body.getToDate() != null) {
            search.put("end", Long.toString(body.getToDate().toGregorianCalendar().getTimeInMillis() / 1000L));
        }
        if (body.getPatientSSNs() != null && body.getPatientSSNs().getValue().size() > 0) {
            search.put("ssn", body.getPatientSSNs().getValue().get(0));
        }
        if (body.getPatientGivenNames() != null && body.getPatientGivenNames().getValue().size() > 0) {
            search.put("first", body.getPatientGivenNames().getValue().get(0));
        }
        if (body.getPatientLastNames() != null && body.getPatientLastNames().getValue().size() > 0) {
            search.put("last", body.getPatientLastNames().getValue().get(0));
        }
        if (body.getPageInfo() != null) {
            PageInfoType pageInfo = body.getPageInfo();
            pageSize = pageInfo.getPageSize();
            pageNumber = pageInfo.getPageNumber();
            if (pageSize > 0) {
                search.put("records", Integer.toString(pageSize));
            }
            search.put("page", Integer.toString(pageNumber));
        }
        else {
            pageSize = -1;
            pageNumber = 0;
        }

        if (body.getSortFields() != null && body.getSortFields().getSortField() != null) {
            SortFieldsType sortFields = body.getSortFields();
            String order = sortFields.getSortField().get(0).getField().name();
            order = converOrder(order);
            if (sortFields.getSortField().get(0).getDirection().equals(SortDirection.ASC)) {
                order += " asc";
            }
            else {
                order += " desc";
            }
            search.put("order", order);
        }
        AuditsType audits = this.getAudits(search);
        int size = audits.getAudit().size();
        PageInfoType pageInfo = new PageInfoType();
        pageInfo.setPageSize(pageSize != -1 ? Math.min(pageSize, size) : size);
        pageInfo.setPageNumber(pageNumber);
        ret.setAudits(audits);
        ret.setPageInfo(pageInfo);
        return ret;

    }
    
    @Override
    public Long getAuditsCount(GetAudits body) throws DirectServiceException {
         GetAuditsResponse ret = new GetAuditsResponse();
        HashMap<String,String> search= new HashMap<String,String>();
        int pageSize = -1, pageNumber = 0;
        
        
            if (body.getFromDate() != null) {
                search.put("start", Long.toString(body.getFromDate().toGregorianCalendar().getTimeInMillis()/1000L));
            }
            if (body.getToDate() != null) {
                search.put("end", Long.toString(body.getToDate().toGregorianCalendar().getTimeInMillis()/1000L));
            }
            if (body.getPatientSSNs() != null && body.getPatientSSNs().getValue().size() > 0) {
                search.put("ssn", body.getPatientSSNs().getValue().get(0));
            }
            if (body.getPatientGivenNames() != null && body.getPatientGivenNames().getValue().size() > 0) {
                search.put("first", body.getPatientGivenNames().getValue().get(0));
            }
            if (body.getPatientLastNames() != null && body.getPatientLastNames().getValue().size() > 0) {
                search.put("last", body.getPatientLastNames().getValue().get(0));
            }
            /*if (body.getPageInfo() != null) {
                PageInfoType pageInfo = body.getPageInfo();
                pageSize = pageInfo.getPageSize();
                pageNumber = pageInfo.getPageNumber();
                if(pageSize > 0){
                    search.put("records", Integer.toString(pageSize));
                }
                search.put("page", Integer.toString(pageNumber));
            }
            else {
                pageSize = -1;
                pageNumber = 0;
            }*/
            
            /*if (body.getSortFields() != null && body.getSortFields().getSortField() != null) {
                SortFieldsType sortFields = body.getSortFields();
                String order = sortFields.getSortField().get(0).getField().name();
                order = converOrder(order);
                if(sortFields.getSortField().get(0).getDirection().equals(SortDirection.ASC)){
                    order += " asc";
                }
                else{
                    order += " desc";
                }
                search.put("order", order);
            }*/
            AuditsType audits = this.getAudits(search);
            Long totalCount = new Long(audits.getAudit().size());
        return totalCount;
    
    }

    @Override
    public GetAuditsSummaryResponse getAuditSummary(GetAuditsSummary audit) throws DirectServiceException
    {
        GetAuditsSummaryResponse ret = new GetAuditsSummaryResponse();
        HashMap<String, String> search = new HashMap<String, String>();
        if (audit.getFromDate() != null) {
            search.put("start", Long.toString(audit.getFromDate().toGregorianCalendar().getTimeInMillis() / 1000L));
        }
        if (audit.getToDate() != null) {
            search.put("end", Long.toString(audit.getToDate().toGregorianCalendar().getTimeInMillis() / 1000L));
        }

        ret.setAuditSummaries(getAuditSummary(search));
        ret.setGroupByFields(audit.getGroupByFields());
        return ret;
    }

    private AuditSummariesType getAuditSummary(HashMap<String, String> search) throws DirectServiceException
    {
        AuditSummariesType ret = new AuditSummariesType();
        String search_url = this.createSearchString(search);
        Document doc = this.getDoc(((String) props.get("direct.auditsummary")) + search_url);

        if (doc != null) {
            NodeList nList = doc.getElementsByTagName("item");

            for (int temp = 0; temp < nList.getLength(); temp++) {

                Node nNode = nList.item(temp);

                if (nNode.getNodeType() == Node.ELEMENT_NODE) {
                    Element eElement = (Element) nNode;
                    AuditSummaryType audit = new AuditSummaryType();
                    SummaryFieldsType sumField = new SummaryFieldsType();
                    sumField.getSummaryField().add(eElement.getElementsByTagName("sent_to").item(0).getTextContent());
                    audit.setSummaryFields(sumField);
                    String total = eElement.getElementsByTagName("total").item(0).getTextContent();
                    //  int count = Integer.getInteger(eElement.getElementsByTagName("total").item(0).getTextContent());
                    audit.setCount(Long.parseLong(total));
                    ret.getAuditSummary().add(audit);
                }
            }
        }

        return ret;
    }

    private String converOrder(String order)
    {
        if (order.equals("PATIENT_SSN")) {
            return "ssn";
        }
        if (order.equals("PATIENT_GIVEN_NAME")) {
            return "first";
        }
        if (order.equals("PATIENT_LAST_NAME")) {
            return "last";
        }
        if (order.equals("AUDIT_TIME")) {
            return "disclosed";
        }
        if (order.equals("DOCUMENT_TITLE")) {
            return "title";
        }
        if (order.equals("ORGANIZATION_NAME")) {
            return "recipient";
        }
        if (order.equals("USER_ID")) {
            return "username";
        }
        if (order.equals("PURPOSE_FOR_USE")) {
            return "purpose";
        }
        //can't sort by
        return "disclosed";
    }
}
