#!/bin/bash

# directories to include in the sync.
INCLUDE="Fortify_vap.sh\|vap.fpr\|nvap-\|lib\|pom.xml"

# directories/files to exclude from the sync.
EXCLUDE=".git"

# Location of RTC sandbox directory where you loaded the DAS sources.
SANDBOX_DIR="../NVAP_vap-2.6.4"

# name of RTC component/directory that contains the sources.  This
# should never change.
COMPONENT_DIR="NVAP_vap"

if [ -z "$1" -o -z "$2" ]; then
  echo "Usage: copyChangesAndTag.sh sinceTag newTag"
  exit 85
fi

echo "Changes since $1."
git diff --name-status $1 HEAD | grep $INCLUDE | grep -v $EXCLUDE
read -p "Proceed with copy (y/N)? " proceed

if [ -z "$proceed" -o "$proceed" != "Y" -a "$proceed" != "y" ]; then
  exit 0
fi

echo "Deleting files since $1 tag."
git diff --name-status --no-renames "$1" HEAD | grep $INCLUDE | grep -v $EXCLUDE | grep ^D | awk -F "\t" '{ print $2 }' | xargs -I{} rm -v "$SANDBOX_DIR/$COMPONENT_DIR/{}"

echo "Copying changes since $1 tag."
git diff --name-status --no-renames "$1" HEAD | grep $INCLUDE | grep -v $EXCLUDE | grep -v ^D | awk -F "\t" '{ print $2 }' | xargs -I{} cp -v --parents "{}" "$SANDBOX_DIR/$COMPONENT_DIR/"

echo "Creating tag $2."
git tag "$2"
