#=========================================================================================================#
#                                                                                                         #
#                                          WLST_script                                                    #
# Date : 1/9/2017                                                                                         #
# Environment: 1). PRE-PROD and                                                                           #
#              2). PROD                                                                                   #
#                                                                                                         #
# Purpose: At the end of the successful execution, it  results in, for the current Weblogic domain:       #
#          1. destroys the existing MaxThreadsConstraints object named, 'MaxThreadsConstraint-0'          #
#          2. destroys the existing MinThreadsConstraints object named, 'MinThreadsConstraint-0'          #
#          3. destroys the existing WorkManager bean object named, 'wm/Adapter'                           #
# This is an WLST offline configuration script for  AITC to run in an existing domain.                    #
#                                                                                                         #
#                                                                                                         #
# Usage:                                                                                                  #
#      java weblogic.WLST <WLST_script>                                                                   #
#                                                                                                         #
#=========================================================================================================#

startEdit()

editService.getConfigurationManager().removeReferencesToBean(getMBean('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-0'))

cd('/SelfTuning/adapter_devl')
cmo.destroyMaxThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-0'))

editService.getConfigurationManager().removeReferencesToBean(getMBean('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-0'))
cmo.destroyMinThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-0'))

editService.getConfigurationManager().removeReferencesToBean(getMBean('/SelfTuning/adapter_devl/WorkManagers/wm/Adapter'))
cmo.destroyWorkManager(getMBean('/SelfTuning/adapter_devl/WorkManagers/wm/Adapter'))

activate()

startEdit()
cmo.createMaxThreadsConstraint('MaxThreadsConstraint-PD')

cd('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-PD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(100)
cmo.unSet('ConnectionPoolName')

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createMinThreadsConstraint('MinThreadsConstraint-PD')

cd('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-PD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(5)

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createWorkManager('wm/OutboundPD')

cd('/SelfTuning/adapter_devl/WorkManagers/wm/OutboundPD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))

activate()

startEdit()
cmo.setMinThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-PD'))
cmo.setMaxThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-PD'))
cmo.setIgnoreStuckThreads(false)

activate()

startEdit()
cmo.setNotes('This work manager is used for outbound service of Patient Discovery')

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createMaxThreadsConstraint('MaxThreadsConstraint-RD')

cd('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-RD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(100)
cmo.unSet('ConnectionPoolName')

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createMinThreadsConstraint('MinThreadsConstraint-RD')

cd('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-RD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(5)

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createWorkManager('wm/OutboundRD')

cd('/SelfTuning/adapter_devl/WorkManagers/wm/OutboundRD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))

activate()

startEdit()
cmo.setMinThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-RD'))
cmo.setMaxThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-RD'))
cmo.setIgnoreStuckThreads(false)

activate()

startEdit()
cmo.setNotes('This work manager is used for outbound service of Document Retrival')

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createMaxThreadsConstraint('MaxThreadsConstraint-QD')

cd('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-QD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(100)
cmo.unSet('ConnectionPoolName')

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createMinThreadsConstraint('MinThreadsConstraint-0')

cd('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-0')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(5)

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createWorkManager('wm/OutboundQD')

cd('/SelfTuning/adapter_devl/WorkManagers/wm/OutboundQD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))

activate()

startEdit()

cd('/SelfTuning/adapter_devl')
cmo.createMinThreadsConstraint('MinThreadsConstraint-QD')

cd('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-QD')
set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_devl_admin,Type=Server')], ObjectName))
cmo.setCount(5)

activate()

startEdit()

cd('/SelfTuning/adapter_devl/WorkManagers/wm/OutboundQD')
cmo.setMinThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MinThreadsConstraints/MinThreadsConstraint-QD'))
cmo.setMaxThreadsConstraint(getMBean('/SelfTuning/adapter_devl/MaxThreadsConstraints/MaxThreadsConstraint-QD'))
cmo.setIgnoreStuckThreads(false)

activate()

startEdit()
cmo.setNotes('This work manager is used for outbound service of Document Query')

activate()

startEdit()
