#!/bin/sh

echo "Increaming swap space."
echo "  Creating partition on 2nd disk."
sed -e 's/\s*\([\+0-9a-zA-Z]*\).*/\1/' << STOP | fdisk /dev/sdb
  n # new partition
  p # primary partition
  1 # partition number 1
    # default - start at beginning of disk 
    # default - end at end of disk
  t # change partition type
    # default partion 1
  8e # LVM partition
  p # print the in-memory partition table
  w # write the partition table
  q # and we're done
STOP

echo "  Extending swap volume."
swapoff /dev/dm-1
vgextend VolGroup00 /dev/sdb1
lvextend /dev/VolGroup00/LogVol01 -L+2G
mkswap /dev/VolGroup00/LogVol01
swapon -va
free -h

echo "Installing Desktop"
yum -y groupinstall "Desktop" "Desktop Platform" "X Window System" "Fonts"
yum -y install xorg-x11-apps xterm zip unzip vim bc net-tools

echo "Adding oracle user."
groupadd dba
useradd oracle -g dba
mkdir -p /u01/app
chown -R oracle:dba /u01/app

echo "Adding vagrant to dba group."
usermod -a -G dba vagrant

echo "Downloading installers..."
if [ ! -d /ehx/.vagrant/Software/ehx ]; then
  mkdir -p /ehx/.vagrant/Software/ehx
  curl https://downloads.vetsez.net/Downloads/jdk-8u121-linux-x64.tar.gz -o /ehx/.vagrant/Software/ehx/jdk-8u121-linux-x64.tar.gz
  curl https://downloads.vetsez.net/Downloads/fmw_12.2.1.2.0_wls_Disk1_1of1.zip -o /ehx/.vagrant/Software/ehx/fmw_12.2.1.2.0_wls_Disk1_1of1.zip
  curl https://downloads.vetsez.net/Downloads/oracle-xe-11.2.0-1.0.x86_64.rpm.zip -o /ehx/.vagrant/Software/ehx/oracle-xe-11.2.0-1.0.x86_64.rpm.zip
fi

echo "Installing JDK."
runuser -l oracle << STOP
mkdir -p /u01/app/oracle/java
tar -C /u01/app/oracle/java -xzf /ehx/.vagrant/Software/ehx/jdk-8u121-linux-x64.tar.gz
pushd /u01/app/oracle/java
ln -s jdk1.8.0_121 latest
popd
STOP

echo "Instaling weblogic"
runuser -l oracle << STOP
echo "  Creating oraInst.loc."
mkdir -p /u01/app/oracle/oraInventory
cat << STOP2 >/u01/app/oracle/oraInventory/oraInst.loc
inventory_loc=/u01/app/oracle/oraInventory
inst_group=dba
STOP2
echo "  Running WebLogic Installer."
export JAVA_HOME=/u01/app/oracle/java/latest
pushd /tmp
unzip /ehx/.vagrant/Software/ehx/fmw_12.2.1.2.0_wls_Disk1_1of1.zip
/u01/app/oracle/java/latest/bin/java -Djava.security.egd=file:/dev/./urandom -jar fmw_12.2.1.2.0_wls.jar -silent -responseFile /ehx/vagrant-scripts/wls.rsp -invPtrLoc /u01/app/oracle/oraInventory/oraInst.loc
popd
echo "  Configure WebLogic to use /dev/urandom."
cat << STOP2 >>/u01/app/oracle/weblogic/oracle_common/common/bin/commBaseEnv.sh
# use /dev/urandom to generate random numbers to speed up weblogic.
# change made here so that everything we use in WL installation
# can benefit.
export JAVA_OPTIONS="\\\$JAVA_OPTIONS -Djava.security.egd=file:/dev/./urandom"
export CONFIG_JVM_ARGS="\\\$CONFIG_JVM_ARGS -Djava.security.egd=file:/dev/./urandom"
STOP2
STOP

echo "Installing Oracle XE"
unzip /ehx/.vagrant/Software/ehx/oracle-xe-11.2.0-1.0.x86_64.rpm.zip -d /tmp/XE
pushd /tmp/XE/Disk1
rpm -ivh oracle-xe-11.2.0-1.0.x86_64.rpm >/tmp/XE/install.log
/etc/init.d/oracle-xe configure responseFile=/ehx/vagrant-scripts/xe.rsp >>/tmp/XE/install.log
popd

echo "Add Java, Oracle and WebLogic to paths."
tee -a ~vagrant/.bash_profile ~oracle/.bash_profile << STOP
alias mocks='cd /u01/app/domains/ehx_devl/ && ./startDomainDebugWithMocks.sh'
alias stopwl='cd /u01/app/domains/ehx_devl/bin && ./stopWebLogic.sh'
alias logs='cd /u01/app/domains/ehx_devl/servers/admin/logs  &&  tail -f ehx_devl.log -n 14'
export JAVA_HOME=/u01/app/oracle/java/latest
export WL_HOME=/u01/app/oracle/weblogic
export PATH=\$WL_HOME/oracle_common/common/bin:\$JAVA_HOME/bin:\$PATH
. /u01/app/oracle/product/11.2.0/xe/bin/oracle_env.sh
STOP

echo "Give everyone in dba group write privs on /u01/app."
chmod -R g+w /u01/app

#echo "Set correct permissions on authorized_keys."
#chmod 600 ~vagrant/.ssh/authorized_keys

echo "Set up the ADAPTER schema."
runuser -l oracle << STOP
pushd /ehx/DBScripts
. ./BuildDB.sh
popd
STOP

echo "Set up ehx_devl weblogic domain."
runuser -l vagrant << STOP
wlst.sh /ehx/vagrant-scripts/ehx_devl.py
cp /ehx/vagrant-scripts/weblogic/* /u01/app/domains/ehx_devl
STOP

echo "Add MOCK-HOST to /etc/hosts."
echo -e "IP      \tMOCK-HOST" >>/etc/hosts

