/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.das.datamanager.vistalinksetup;

import gov.va.med.nhin.adapter.utils.*;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;
import javax.xml.xpath.*;

import org.w3c.dom.*;

/**
 *
 * @author DNS   
 */
public class VistALinkSetup
{
//    private static DasEsapiValidator dasEsapiValidator = (DasEsapiValidator) ESAPI.validator();

    static class ConnectorInfo
    {
        public String jndiName;
        public String stationNumber;
    }
    
    /**
     * @param args the command line arguments
     */
    static public void main(String[] args)
    {
    	FileReader fileReader = null;
        try {
            Properties properties = new Properties();
            String configDir = System.getProperty("gov.va.das.datamanager.vistalinksetup.configDir", "./config");
/*
            try {
            	configDir = dasEsapiValidator.getValidInput(
    			        "Validate configDir: " + configDir, configDir, "DirectoryName", false, false);
    		} 
        	catch (ValidationException e) {
    			String validationErrStr = "Failed input validation of the configDir. " + e.getMessage();
    			throw new DataManagerException(validationErrStr, e);
    		}
*/          
            String propertyFileName = configDir + "/VistALinkSetup.properties";
            System.out.println("Reading properties file: "+propertyFileName);
            fileReader = new FileReader(propertyFileName);
            properties.load(fileReader);

            String vistALinkConnectorConfigFileName = properties.getProperty("vistALinkConnectorConfigFileName");
            System.out.println("vistALinkConnectorConfigFileName: "+vistALinkConnectorConfigFileName);
            
            String raTemplateDir = properties.getProperty("raTemplateDir");
            System.out.println("raTemplateDir: "+raTemplateDir);
            
            String raStageDir = properties.getProperty("raStageDir");
            System.out.println("raStageDir: "+raStageDir);
            
            String connectionsTemplateFileName = properties.getProperty("connectionsTemplateFileName");
            System.out.println("connectionsTemplateFileName: "+connectionsTemplateFileName);
            
            String connectionsStageFileName = properties.getProperty("connectionsStageFileName");
            System.out.println("connectionsStageFileName: "+connectionsStageFileName);
            
            String connectionKeyPrefix = properties.getProperty("connectionKeyPrefix");
            System.out.println("connectionKeyPrefix: "+connectionKeyPrefix);
            
            String connectionUserName = properties.getProperty("connectionUserName");
            System.out.println("connectionUserName: "+connectionUserName);
            
            Properties connectionProperties = loadConnectionProperties(connectionsTemplateFileName);
            ConnectorInfo[] connectorInfos = getConnectorInfos(vistALinkConnectorConfigFileName);
            
            for (ConnectorInfo connectorInfo : connectorInfos) {
                String connectorName = makeConnectorName(connectorInfo.jndiName);
                copyTemplateToStage(raTemplateDir, raStageDir, connectorName);
                fixConfiguration(raStageDir, connectorName, connectorInfo.jndiName);
                addConnection(connectionProperties, connectorInfo, connectionUserName, connectionKeyPrefix);
            }
            
            storeConnectionProperties(connectionsStageFileName, connectionProperties);
        }
        catch (Throwable t) {
            System.out.println("Unrecoverable Error!");
            t.printStackTrace();
        }
        finally {
        	safeClose(fileReader);
        }
    }

    static private ConnectorInfo[] getConnectorInfos(String connectorConfigFileName)
        throws Exception
    {
        List<ConnectorInfo> ret = new ArrayList<ConnectorInfo>();

        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        
		// gify additions to address XXE issues
		//String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
		//dbf.setFeature(FEATURE, true);

		//FEATURE = "http://xml.org/sax/features/external-parameter-entities";
		//dbf.setFeature(FEATURE, false);

		//FEATURE = "http://xml.org/sax/features/external-general-entities";
		//dbf.setFeature(FEATURE, false);

		//dbf.setXIncludeAware(false);
		//dbf.setExpandEntityReferences(false);
		//dbf.setNamespaceAware(true);
       
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(connectorConfigFileName);
        if (doc==null) {
            System.out.println("Warning, connectorConfigFileName: "+connectorConfigFileName + " was not parsed.");
        }

        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        NodeList nodeList = (NodeList) xpath.evaluate("connectors/connector", doc, XPathConstants.NODESET);

        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            ConnectorInfo ci = new ConnectorInfo();
            ci.jndiName = node.getAttributes().getNamedItem("jndiName").getTextContent();
            ci.stationNumber = node.getAttributes().getNamedItem("primaryStation").getTextContent();
            
            ret.add(ci);
        }

        return ret.toArray(new ConnectorInfo[ret.size()]);
    }

    static private String makeConnectorName(String connectorJNDIName)
    {
        return connectorJNDIName.replace("/", "");
    }

    static private void copyTemplateToStage(String templateDir, String stageDir, String connectorName)
        throws Exception
    {
/*        try {
        	templateDir = dasEsapiValidator.getValidInput(
			        "Validate templateDir: " + templateDir, templateDir, "DirectoryName", false, false);
		} 
    	catch (ValidationException e) {
			String validationErrStr = "Failed input validation of the templateDir. " + e.getMessage();
			throw new DataManagerException(validationErrStr, e);
		}
*/
        File source = new File(templateDir);
/*        
        try {
        	stageDir = dasEsapiValidator.getValidInput(
			        "Validate stageDir: " + stageDir, stageDir, "DirectoryName", false, false);
		} 
    	catch (ValidationException e) {
			String validationErrStr = "Failed input validation of the stageDir. " + e.getMessage();
			throw new DataManagerException(validationErrStr, e);
		}
        
        try {
        	connectorName = dasEsapiValidator.getValidInput(
			        "Validate connectorName: " + connectorName, connectorName, "DirectoryName", false, false);
		} 
    	catch (ValidationException e) {
			String validationErrStr = "Failed input validation of the connectorName. " + e.getMessage();
			throw new DataManagerException(validationErrStr, e);
		}
*/        
        File dest = new File(stageDir + File.separator + connectorName);
        File stage = new File(stageDir);

        if (!stage.exists()) {
            System.out.println("Making: "+stage.getAbsolutePath());
            stage.mkdir();
        }

        copyDirectory(source, dest);
    }

    static private void copyDirectory(File sourceLocation, File targetLocation)
        throws IOException
    {
        System.out.println("Copying from: "+sourceLocation.getAbsolutePath() + " to: "+targetLocation);
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                System.out.println("Making: "+targetLocation.getAbsolutePath());
                targetLocation.mkdirs();
            }

            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; i++) {
                copyDirectory(new File(sourceLocation, children[i]),
                    new File(targetLocation, children[i]));
            }
        }
        else {
            InputStream in = null;
            OutputStream out = null;

            try {
                in = new FileInputStream(sourceLocation);
                out = new FileOutputStream(targetLocation);           	
            	
                // Copy the bits from instream to outstream
                byte[] buf = new byte[1024];
                int len;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }            	
            }
            finally {
            	safeClose(in);
            	safeClose(out);
            }
        }
    }

    static private void fixConfiguration(String stageDir, String connectorName, String jndiName)
        throws Exception
    {
/*        try {
        	stageDir = dasEsapiValidator.getValidInput(
			        "Validate stageDir: " + stageDir, stageDir, "DirectoryName", false, false);
		} 
    	catch (ValidationException e) {
			String validationErrStr = "Failed input validation of the stageDir. " + e.getMessage();
			throw new DataManagerException(validationErrStr, e);
		}
        
       try {
    	   connectorName = dasEsapiValidator.getValidInput(
			        "Validate connectorName: " + connectorName, connectorName, "DirectoryName", false, false);
		} 
    	catch (ValidationException e) {
			String validationErrStr = "Failed input validation of the connectorName. " + e.getMessage();
			throw new DataManagerException(validationErrStr, e);
		}
*/    	
    	File configDir = new File(stageDir + File.separator + connectorName + File.separator + "META-INF");
        File configFile = new File(configDir, "weblogic-ra.xml");
        File tempFile = File.createTempFile("out", ".xml", configDir);

        BufferedReader in = null;
        BufferedWriter out = null;

        try {
            in = new BufferedReader(new FileReader(configFile));
            out = new BufferedWriter(new FileWriter(tempFile));
 
            while (in.ready()) {
                String line = in.readLine();
                String replacement = line.replaceAll("\\$\\{vlj\\.jndi\\.name\\}", jndiName);
                out.write(replacement);
                out.write("\n");
            }
        }
        finally {
        	safeClose(in);
        	safeClose(out);
        }

        configFile.delete();
        tempFile.renameTo(configFile);
    }
    
    static private Properties loadConnectionProperties(String filename)
    {
/*        try {
        	filename = dasEsapiValidator.getValidInput(
			        "Validate filename: " + filename, filename, "DirectoryName", false, false);
		} 
    	catch (ValidationException e) {
			String validationErrStr = "Failed input validation of the filename. " + e.getMessage();
			throw new DataManagerException(validationErrStr, e);
		}
*/    	
        System.out.println("Looking for properties file: "+filename);
    	File file = new File(filename);
        
        if (!file.exists()) {
            System.out.println(filename+" does not exist.  Will create file");
            filename = (file.getParent() != null ? file.getParent() : "") + File.separator + System.getenv("HOSTNAME") + "-" + file.getName();
            System.out.println("Will try to use: "+filename);
        }
        
        Properties ret;
        try {
            ret = PropertiesCollectionFactory.getPropertiesCollection(filename);
        }
        catch (Exception e) {
            System.out.println("Did not find "+filename+".  Returning empty properties.");
            ret = new Properties();
        }
        
        return ret;
    }
    
    static private void storeConnectionProperties(String filename, Properties connectionProperties)
        throws Exception
    {
        File f = new File(filename);
        f.createNewFile();
        PropertiesCollectionFactory.storeProperties(filename, connectionProperties);
    }
    
    static private void addConnection(Properties connectionProperties, ConnectorInfo connectorInfo, String connectionUsername, String connectionKeyPrefix)
    {
        Properties properties = new Properties();
        properties.setProperty("JNDIName", connectorInfo.jndiName);
        properties.setProperty("username", connectionUsername);
        properties.setProperty("division", connectorInfo.stationNumber);
        connectionProperties.put(connectionKeyPrefix + connectorInfo.stationNumber, properties);
    }
    
    static void safeClose(Closeable stream) {
	    try {
			  if (stream != null) {
			    	stream.close();
			  }
	    } 
	    catch (IOException e) {
	    	System.out.println("VistALinkSetup: Exception closing stream");
	    }
    }
}