<#ftl strip_whitespace=true>
<#include "../macros/allergyMacros.ftl">
<#include "../macros/defaultMacros.ftl">

<#if comments??>
<table id="_nbImmunizationComments">
	<thead>
		<tr>
			<th>Comments</th>
		</tr>
	</thead>
	<tbody>
		<#if comments??>
			<#list comments as comment>
				<tr>
					<td>${comment}</td>
				</tr>
			</#list>
		</#if>
	</tbody>
</table>
</#if>
<table ID='_nbImmunization' border='1' width='100%'>
	<thead>
		<tr>
			<th>Immunization</th>
			<th>Series</th>
			<th>Date Issued</th>
			<th>Reaction</th>
			<th>Comments</th>
			<th>Immunization Refused</th>
			<th>Refusal Reason</th>
			<th>Provider</th>
			<th>Source</th>
			<th>Drug Manufacturer</th>
			<th>Lot Number</th>
		</tr>
	</thead>
	<tbody>
		<#if immunizations??>
		<#list immunizations as immunization>
		<tr>
			<#-- Immunization -->
			<td>
				<#if immunization.material??>
					<@displayCodeWithDefault immunization.material />
				<#else>
					<@displayDefault />
				</#if>
			</td>
			<#-- Series -->
			<td>
					${immunization.series!"--"}
			</td>
			<#-- Date Issued -->
			<@displayTime immunization />
			<td>

			</td>
			<#-- Reaction -->
			<#-- If adding severity look at allergies -->
			<td>
				<#if immunization.reactions??>
					<#list immunization.reactions as reaction>
						<@displayReactionWithDefault reaction /> <#if reaction_has_next>// </#if>
					</#list>
				<#else>
					<@displayDefault />
				</#if>
			</td>
			<#-- Comments -->
			<td>
				<@displayTextWithDefault immunization />
			</td>
			<#-- Immunization Refused -->
			<td>
				<#if immunization.refused == "1">
					Yes
				<#else>
					No
				</#if>
			</td>
			<#-- Refusal Reason -->
			<td>
				<#if immunization.reason??>
					<@displayCodeWithDefault immunization.reason />
				<#else>
					<@displayDefault />
				</#if>
			</td>
			<#-- Provider -->
			<td>
				<@displayDefault />
			</td>
			<#-- Source -->
			<td>
				<@valueOrDefault immunization.source />
			<#-- ${immunization.source!<@displayDefault />} -->
			</td>
			<#-- Drug Manufacturer -->
			<td>
				<@valueOrDefault immunization.mansource />
			</td>
			<#-- Lot Number -->
			<td>
				<@displayTextWithDefault immunization.lot />
			</td>				
		</tr>
		</#list>
		</#if>
	</tbody>
</table>