package gov.va.ccd.service.value.objects.impl;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ItemObject
{
	private String value = null;
	private String reference = null;

	public ItemObject()
	{
	}

	public ItemObject(final String value)
	{
		this(value, null);
	}

	public ItemObject(final String value, final String reference)
	{
		this.value = StringEscapeUtils.escapeHtml4(value);
		this.reference = reference;
	}

	/**
	 * @return the value
	 */
	public String getValue()
	{
		return value;
	}

	public String getValueWithRefDefault()
	{
		if(hasReference())
		{
			return "<content ID=\"" + reference + "\">" + StringEscapeUtils.escapeXml(value) + "</content>";
		}
		if(!hasValue())
		{
			return "--";
		}
		return StringEscapeUtils.escapeXml(value);
	}

	public void setBoth(final String value, final String ref)
	{
		this.setValue(value);
		this.setReference(ref);
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(String value)
	{
		if(!"null".equalsIgnoreCase(value))
		{
			this.value = value;
		}
	}

	/**
	 * @return the reference
	 */
	public String getReference()
	{
		return reference;
	}

	/**
	 * @param reference the reference to set
	 */
	public void setReference(String reference)
	{
		if(StringUtils.isNotBlank(reference))
		{
			this.reference = reference;
		}
	}

	/**
	 * 
	 * @return
	 */
	public boolean hasValue()
	{
		return StringUtils.isNotBlank(value);
	}

	/**
	 * 
	 * @return
	 */
	public boolean hasReference()
	{
		return StringUtils.isNotBlank(reference);
	}

	public boolean isEmpty()
	{
		return !hasReference() && !hasValue();
	}

	@Override
	public String toString()
	{
		return getValue();
	}
}
