package gov.va.ccd.consol.component.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import gov.va.ccd.consol.AbstractConsolComponent;
import gov.va.ccd.consol.component.transform.TransformerConsolCore;
import gov.va.ccd.mapper.TemplateMapper;
import gov.va.ccd.service.value.object.SectionValueObject;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.Participant2;
import org.openhealthtools.mdht.uml.cda.ParticipantRole;
import org.openhealthtools.mdht.uml.cda.consol.AdvanceDirectivesSection;
import org.openhealthtools.mdht.uml.cda.consol.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.hl7.datatypes.ANY;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;
import org.openhealthtools.mdht.uml.hl7.vocab.ParticipationType;
import org.openhealthtools.mdht.uml.hl7.vocab.RoleClassRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author ChmaraC
 * 
 */
public class AdvanceDirConsolComponent extends AbstractConsolComponent<AdvanceDirectivesSection>
{
	private static final Logger logger = LoggerFactory.getLogger(AdvanceDirConsolComponent.class);

	public AdvanceDirConsolComponent(ContinuityOfCareDocument ccd)
	{
		super(ccd.getAdvanceDirectivesSection(), ccd);
	}

	@Override
	protected String generateXml()
	{
		if(values.isEmpty())
			return StringUtils.EMPTY;

		try
		{
			Configuration cfg = TemplateMapper.getInstance().getCfg();
			Template temp = cfg.getTemplate("ccda/AdvanceDirective.ftl");
			/* Merge data-model with template */

			StringWriter out = new StringWriter();
			temp.process(values, out);
			return out.toString();
		}
		catch(IOException e)
		{
			logger.error("Error occurred", e);
		}
		catch(TemplateException e)
		{
			logger.error("Error occurred", e);
		}
		return StringUtils.EMPTY;
	}

	@Override
	protected void createObjects()
	{
		List<Map<String, Object>> directives = new ArrayList<Map<String, Object>>();
		for(Observation obs : section.getObservations())
		{
			Map<String, Object> map = new HashMap<String, Object>();
			// Type
			TransformerConsolCore.mapCode(map, "", obs.getCode(), narrativeText);
			// Effective Date
			TransformerConsolCore.mapEffectiveTime(map, obs.getEffectiveTime());

			// Title
			for(ANY any : obs.getValues())
			{
				if(any instanceof CD)
				{
					TransformerConsolCore.mapWrappedCode(map, "title", (CD) any, narrativeText);
				}
			}

			// Find Custodian
			for(Participant2 participant : obs.getParticipants())
			{
				if(ParticipationType.CST.equals(participant.getTypeCode()))
				{
					ParticipantRole role = participant.getParticipantRole();
					if(RoleClassRoot.AGNT.equals(role.getClassCode()))
					{
						TransformerConsolCore.mapParticipantRole(map, "cust", role, narrativeText);
					}
				}
			}

			// Find other sources
			TransformerConsolCore.mapSources(map, obs.getAuthors(), obs.getPerformers(), obs.getParticipants(), obs.getInformants());
			if(!map.isEmpty())
			{
				directives.add(map);
			}
		}

		if(CollectionUtils.isNotEmpty(directives))
		{
			values.put("directives", directives);
		}
	}

	@Deprecated
	public List<SectionValueObject> getSectionData()
	{
		throw new UnsupportedOperationException("Get Section data is for legacy code.");
	}

}
