// Decompiled by DJ v3.12.12.96 Copyright 2011 Atanas Neshkov  Date: 2/18/2014 3:29:09 PM
// Home Page: http://members.fortunecity.com/neshkov/dj.html  http://www.neshkov.com/dj.html - Check often for new version!
// Decompiler options: packimports(3) 
// Source File Name:   ImmunizationComponent.java

package gov.va.ccd.components.impl;

import gov.va.ccd.components.transform.Transformer;
import gov.va.ccd.service.util.Utils;
import gov.va.ccd.service.value.objects.impl.ImmunizationVO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.openhealthtools.mdht.uml.cda.Consumable;
import org.openhealthtools.mdht.uml.cda.Entry;
import org.openhealthtools.mdht.uml.cda.EntryRelationship;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.ccd.ImmunizationsSection;
import org.openhealthtools.mdht.uml.hl7.datatypes.ANY;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;
import org.openhealthtools.mdht.uml.hl7.datatypes.CE;
import org.openhealthtools.mdht.uml.hl7.datatypes.ENXP;
import org.openhealthtools.mdht.uml.hl7.datatypes.INT;
import org.openhealthtools.mdht.uml.hl7.datatypes.ON;
import org.openhealthtools.mdht.uml.hl7.datatypes.PN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Immunization Component Section
 * 
 * @author Brad Messerle
 * @since 1.0
 * 
 * @param <S> ImmunizationsSection
 */
public class ImmunizationComponent extends AbstractComponent<ImmunizationsSection>
{
	private static final Logger LOG = LoggerFactory.getLogger(ImmunizationComponent.class);

	public ImmunizationComponent(final ContinuityOfCareDocument ccdDocument)
	{
		super(ccdDocument.getImmunizationsSection(), ccdDocument);
	}

	@Override
	public void execute()
	{
		List<ImmunizationVO> rows = getEncounterRows();
		appendNarrative(generateXml(rows));
	}

	private String generateXml(List<ImmunizationVO> rows)
	{
		StringBuffer sb = new StringBuffer();
		if(CollectionUtils.isNotEmpty(rows))
		{
			if(CollectionUtils.isNotEmpty(this.getComments()))
			{
				sb.append("<table ID='_nbImmunizationComments' border='1' width='100%'>");
				sb.append("<thead>");
				sb.append("<tr><th>Comments</th></tr>");
				sb.append("</thead>");
				sb.append("<tbody>");
				for(String comment : this.getComments())
				{
					sb.append("<tr width='100%'>");
					sb.append("<td width='100%'>");
					sb.append("<p>");
					sb.append(comment);
					sb.append("</p>");
					sb.append("</td></tr>");
				}
				sb.append("</tbody>");
				sb.append("</table>");
			}

			sb.append("<table ID='_nbImmunization' border='1' width='100%'>");
			sb.append("<thead>");
			sb.append("<tr>");
			sb.append("<th>Immunizations</th>");
			sb.append("<th>Series</th>");
			sb.append("<th>Date Issued</th>");
			sb.append("<th>Reaction</th>");
			sb.append("<th>Comments</th>");
			sb.append("<th>Immunization Refused</th>");
			sb.append("<th>Refusal Reason</th>");
			sb.append("<th>Provider</th>");
			sb.append("<th>Source</th>");
			sb.append("<th>Drug Manufacturer</th>");
			sb.append("<th>Lot Number</th>");
			sb.append("</tr>");
			sb.append("</thead>");
			sb.append("<tbody>");
			for(Iterator<ImmunizationVO> iterator = rows.iterator(); iterator.hasNext();)
			{
				ImmunizationVO helper = iterator.next();
				sb.append("<tr>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getProductDN(), helper.getProductRN()) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getSeries(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getDateIssued(), null) + "</td>");
				sb.append("<td>" + Utils.getCommaSeperateString(helper.getReactionList()) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getComments(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getImmunizationRefused(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getRefusedReasonDN(), helper.getRefusedReasonCode()) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getProvider(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getSource(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getDrugManufacture(), null) + "</td>");
				sb.append("<td>" + Utils.getNotNullValue(helper.getLotNumber(), null) + "</td>");
				sb.append("</tr>");

			}

			sb.append("</tbody>");
			sb.append("</table>");
		}
		return sb.toString();

	}

	private List<ImmunizationVO> getEncounterRows()
	{

		List<ImmunizationVO> list = new ArrayList<ImmunizationVO>();
		ImmunizationVO immunizationHelper = null;

		String source = Utils.getSource(this.getCcdDocument());

		if(CollectionUtils.isNotEmpty(section.getEntries()))
		{
			for(Entry entry : section.getEntries())
			{
				immunizationHelper = new ImmunizationVO();

				if(entry != null)
				{
					SubstanceAdministration administration = entry.getSubstanceAdministration();

					if(administration != null)
					{
						// source
						immunizationHelper.setSource(source);

						String adminSource = Utils.getSourceFromSubstanceAdmin(administration);
						if(StringUtils.isNotBlank(adminSource))
						{
							immunizationHelper.setSource(adminSource);
						}

						// override Source
						if(administration.getAuthors() != null && !administration.getAuthors().isEmpty() && administration.getAuthors().get(0).getAssignedAuthor() != null && administration.getAuthors().get(0).getAssignedAuthor().getRepresentedOrganization() != null && !administration.getAuthors().get(0).getAssignedAuthor().getRepresentedOrganization().getNames().isEmpty())
						{
							immunizationHelper.setSource(administration.getAuthors().get(0).getAssignedAuthor().getRepresentedOrganization().getNames().get(0).getText());
						}

						// effective Date
						if(CollectionUtils.isNotEmpty(administration.getEffectiveTimes()))
						{
							immunizationHelper.setDateIssued(administration.getEffectiveTimes().get(0).getValue());
						}

						// Product Display Name/Text

						if(administration.getConsumable() != null && administration.getConsumable().getManufacturedProduct() != null && administration.getConsumable().getManufacturedProduct().getManufacturedMaterial() != null)
						{
							CE value = administration.getConsumable().getManufacturedProduct().getManufacturedMaterial().getCode();

							// String productDN = null;
							if(value != null)
							{
								LOG.debug("code {}:", value);
								LOG.debug("Event Types - code:{}, code system : {}, display name: {} ", value.getCode(), value.getCodeSystem(), value.getDisplayName());
								
								immunizationHelper.setProductDN(value.getDisplayName());

								if(value.getOriginalText() != null && value.getOriginalText().getReference() != null)
								{
									String productRef = value.getOriginalText().getReference().getValue();
									immunizationHelper.setProductRef(productRef);
									immunizationHelper.setProductRN(this.getReferenceValue(productRef));

								}

							}

							// Refusal Reason: New code to use transformer.
							// Reason can be in an act, obs ...
							Map<String, Object> map = new HashMap<String, Object>();
							Transformer.mapReasons(map, administration.getEntryRelationships(), narrativeText);
							if(!map.isEmpty() && map.containsKey("reason"))
							{
								@SuppressWarnings("unchecked")
								Map<String, Object> reasons = (Map<String, Object>) map.get("reason");
								String displayName = (String) reasons.get("codeDisplayName");
								String code = (String) reasons.get("code");
								if(StringUtils.isNotBlank(displayName))
								{
									immunizationHelper.setRefusedReasonDN(displayName);
								}

								if(StringUtils.isNotBlank(code))
								{
									immunizationHelper.setRefusedReasonCode(code);
								}
							}

							// Series and refusal reason
							if(CollectionUtils.isNotEmpty(administration.getEntryRelationships()))
							{
								for(EntryRelationship entryRelationship : administration.getEntryRelationships())
								{
									// Series
									if(entryRelationship.getObservation() != null)
									{
										Observation observation = entryRelationship.getObservation();

										if(observation.getValues() != null && !observation.getValues().isEmpty() && observation.getValues().get(0) instanceof INT)
										{
											INT intvalue = (INT) observation.getValues().get(0);
											if(intvalue != null && intvalue.getValue() != null)
											{
												immunizationHelper.setSeries(intvalue.getValue().toString());
											}
										}

									}

									// reaction (Multiple)
									if(entryRelationship.getTypeCode() != null)
									{
										if(entryRelationship.getTypeCode().toString().trim().equals("CAUS") && entryRelationship.getInversionInd() != null && !entryRelationship.getInversionInd().booleanValue())
										{
											if(entryRelationship.getObservation() != null)
											{
												final Observation observation = entryRelationship.getObservation();

												// Get the Text file next
												String reactionValue = null;
												if(CollectionUtils.isNotEmpty(observation.getValues()))
												{
													// See if there is a display
													// name
													for(ANY obsValue : observation.getValues())
													{
														if(obsValue instanceof CD)
														{
															CD codedValue = (CD) obsValue;
															if(StringUtils.isNotBlank(codedValue.getDisplayName()))
															{
																if(StringUtils.isNotBlank(reactionValue))
																{
																	reactionValue = reactionValue + "," + StringUtils.trim(codedValue.getDisplayName());
																}
																else
																{
																	reactionValue = StringUtils.trim(codedValue.getDisplayName());
																}
															}
														}
													}
												}

												if(StringUtils.isEmpty(reactionValue) && observation.getText() != null)
												{
													String reactionRef = observation.getText().getReference().getValue();
													reactionValue = this.getReferenceValue(reactionRef);
												}

												if(StringUtils.isNotEmpty(reactionValue))
												{
													immunizationHelper.getReactionList().add(reactionValue);
												}
											}
										}
									}
								}
							}

							// immunization refused

							if(administration.getClassCode() != null && administration.getMoodCode() != null)
							{
								if(administration.getClassCode().toString().trim().equals("SBADM") && administration.getMoodCode().toString().trim().equals("EVN") && administration.getNegationInd() != null)
								{
									if(administration.getNegationInd().booleanValue())
									{
										immunizationHelper.setImmunizationRefused("Yes");
									}
									else
									{
										immunizationHelper.setImmunizationRefused("No");
									}
								}

							}

							// provider
							if(administration.getPerformers() != null && !administration.getPerformers().isEmpty() && administration.getPerformers().get(0) != null && administration.getPerformers().get(0).getAssignedEntity() != null && administration.getPerformers().get(0).getAssignedEntity().getAssignedPerson() != null)
							{
								if(administration.getPerformers().get(0).getAssignedEntity().getAssignedPerson().getNames() != null && administration.getPerformers().get(0).getAssignedEntity().getAssignedPerson().getNames().get(0) != null)
								{

									immunizationHelper.setProvider(administration.getPerformers().get(0).getAssignedEntity().getAssignedPerson().getNames().get(0).getText());
								}
							}

							// comments
							if(administration.getText() != null && administration.getText().getReference() != null)
							{
								String commentsRef = administration.getText().getReference().getValue();
								String comments = this.getReferenceValue(commentsRef);
								immunizationHelper.setComments(comments);
							}

							// Drug Manufacture
							if(entry.getSubstanceAdministration().getConsumable() != null)
							{

								final Consumable consumable = entry.getSubstanceAdministration().getConsumable();
								if(consumable.getManufacturedProduct() != null && consumable.getManufacturedProduct().getManufacturerOrganization() != null)
								{
									immunizationHelper.setDrugManufacture(this.getManufactureName(consumable.getManufacturedProduct().getManufacturerOrganization().getNames()));
								}

							}

							// Lot Number
							if(entry.getSubstanceAdministration().getConsumable() != null)
							{

								if(entry.getSubstanceAdministration().getConsumable().getManufacturedProduct() != null && entry.getSubstanceAdministration().getConsumable().getManufacturedProduct().getManufacturedMaterial() != null && entry.getSubstanceAdministration().getConsumable().getManufacturedProduct().getManufacturedMaterial().getLotNumberText() != null)
								{
									immunizationHelper.setLotNumber(entry.getSubstanceAdministration().getConsumable().getManufacturedProduct().getManufacturedMaterial().getLotNumberText().getText());
								}

							}

						}

						list.add(immunizationHelper);
					}

				}

			}
		}
		return list;
	}

	public static String getCommaSeperateString(List<String> list)
	{
		// Auto-generated method stub
		StringBuffer sb = new StringBuffer();
		if(list != null && !list.isEmpty())
		{
			for(String value : list)
			{
				sb.append(value + ", ");

			}
			return removeLastChar(sb.toString());
		}
		return "--";
	}

	public static String getCommaSeperateString(Map<String, String> map)
	{
		// Auto-generated method stub
		StringBuffer sb = new StringBuffer();
		for(Map.Entry<String, String> pairs : map.entrySet())
		{

			sb.append(pairs.getValue() + ", ");

			return removeLastChar(sb.toString());
		}
		return "--";
	}

	private static String removeLastChar(String str)
	{
		return str.substring(0, str.length() - 2);
	}

	public static String getRefList(Map<String, String> mp)
	{
		StringBuffer sb = new StringBuffer();
		sb.append("<list>");

		for(Map.Entry<String, String> pairs : mp.entrySet())
		{
			sb.append("<item>");
			sb.append("<content ID=\"" + pairs.getKey() + "\">" + pairs.getValue() + "</content>");
			sb.append("</item>");
		}

		sb.append("</list>");

		return sb.toString();

	}

	protected String getManufactureName(final List<ON> names)
	{
		final StringBuilder sb = new StringBuilder();

		for(ON name : names)
		{
			sb.append(name.getText());
			sb.append(" ");
		}

		return sb.toString();
	}

	protected String createName(final PN name)
	{
		final StringBuilder sb = new StringBuilder();

		if(StringUtils.isNotBlank(name.getText()))
		{
			return name.getText();
		}

		if(StringUtils.isNotBlank(loopForName(name.getPrefixes())))
		{
			sb.append(loopForName(name.getPrefixes())).append(" ");
		}

		if(StringUtils.isNotBlank(loopForName(name.getGivens())))
		{
			sb.append(loopForName(name.getGivens())).append(" ");
		}

		if(StringUtils.isNotBlank(loopForName(name.getFamilies())))
		{
			sb.append(loopForName(name.getFamilies())).append(" ");
		}

		if(StringUtils.isNotBlank(loopForName(name.getSuffixes())))
		{
			sb.append(loopForName(name.getSuffixes())).append(" ");
		}
		return sb.toString();
	}

	protected String loopForName(final EList<ENXP> names)
	{
		for(ENXP name : names)
		{
			if(StringUtils.isNotBlank(name.getText()))
			{
				return name.getText();
			}
		}

		return null;
	}

	/**
	 * No-op handled above.
	 */
	@Override
	protected String generateXml()
	{
		return null;
	}

	/**
	 * No-op handled above.
	 */
	@Override
	protected void createObjects()
	{

	}

}
