<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:util="vap://gov.va.nvap.common.xsl.util"
	xmlns:patientMatchResponse="http://gov/va/nvap/service/pdq"
	exclude-result-prefixes="util patientMatchResponse">

	<!-- Process the common templates -->
	<xsl:import href="/gov/va/nvap/common/xsl/Common.xsl" />

	<xsl:template match="/RSP_K22">
		<patient-match-response
			xmlns="http://gov/va/nvap/service/pdq">
			<patients>
				<xsl:for-each select="RSP_K22.QUERY_RESPONSE">
					<patient-profile>
						<icn>
							<xsl:value-of select="PID/PID.3[1]/CX.1" />
						</icn>
						<first-name>
							<xsl:value-of select="PID/PID.5/XPN.2" />
						</first-name>
						<middle-initial>
							<xsl:value-of select="PID/PID.5/XPN.3" />
						</middle-initial>
						<last-name>
							<xsl:value-of select="PID/PID.5/XPN.1/FN.1" />
						</last-name>
						<ssn>
							<xsl:value-of select="PID/PID.3[2]/CX.1" />
						</ssn>
						<prefix>
							<xsl:value-of select="PID/PID.5/XPN.5" />
						</prefix>
						<suffix>
							<xsl:value-of select="PID/PID.5/XPN.4" />
						</suffix>
						<gender>
							<xsl:value-of select="PID/PID.8" />
						</gender>
						<xsl:if test="PID/PID.7/TS.1">
							<dob>
								<xsl:value-of
									select="util:getDateFromString(PID/PID.7/TS.1)" />
							</dob>
						</xsl:if>
					</patient-profile>
				</xsl:for-each>
			</patients>
			<xsl:if test="MSA/MSA.1='AE'">
				<error>
					<error-description>
						<xsl:value-of select="MSA/MSA.3" />
					</error-description>
				</error>
			</xsl:if>
		</patient-match-response>
	</xsl:template>
</xsl:stylesheet>
