CREATE TABLE ADAPTER.TRANSLATIONS
(
  TRANSLATION_ID  NUMBER,
  SOURCE_CODESET  VARCHAR2(255 CHAR),
  SOURCE_CODE     VARCHAR2(255 CHAR)            NOT NULL,
  TARGET_CODESET  VARCHAR2(255 CHAR)            NOT NULL,
  TARGET_CODE     VARCHAR2(255 CHAR)            NOT NULL,
  DISPLAY_NAME    VARCHAR2(500 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.TRANSLATIONS_PK ON ADAPTER.TRANSLATIONS
(TRANSLATION_ID);

ALTER TABLE ADAPTER.TRANSLATIONS ADD (
  CONSTRAINT TRANSLATIONS_PK
  PRIMARY KEY
  (TRANSLATION_ID)
  USING INDEX ADAPTER.TRANSLATIONS_PK
  ENABLE VALIDATE);
