CREATE TABLE ADAPTER.INT_FILT_CONST
(
  FILTER_ID           NUMBER                    NOT NULL,
  FILTER_NAME         VARCHAR2(255 BYTE)        NOT NULL,
  FILTER_DESCRIPTION  VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.INT_FILT_CONST_PK ON ADAPTER.INT_FILT_CONST
(FILTER_ID);

CREATE OR REPLACE TRIGGER ADAPTER.INT_FILT_CONST_TRG
BEFORE INSERT
ON ADAPTER.INT_FILT_CONST
FOR EACH ROW
BEGIN
    if :new.FILTER_ID is null then
        :new.FILTER_ID := ADAPTER.INT_FILT_CONST_SEQ.nextval;
    end if;
END INT_FILT_CONST_TRG;
/


ALTER TABLE ADAPTER.INT_FILT_CONST ADD (
  CONSTRAINT INT_FILT_CONST_PK
  PRIMARY KEY
  (FILTER_ID)
  USING INDEX ADAPTER.INT_FILT_CONST_PK
  ENABLE VALIDATE);
