CREATE TABLE ADAPTER.INT_FAC_FILT
(
  FAC_FILT_ID  NUMBER                           NOT NULL,
  FACILITY_ID  NUMBER                           NOT NULL,
  FILTER_ID    NUMBER                           NOT NULL,
  ROOT_NAME    VARCHAR2(255 BYTE)               NOT NULL,
  OBJ_NAME     VARCHAR2(255 BYTE),
  PARAM        VARCHAR2(255 BYTE)               NOT NULL
);


CREATE UNIQUE INDEX ADAPTER.INT_FAC_FILT_PK ON ADAPTER.INT_FAC_FILT
(FAC_FILT_ID);

CREATE OR REPLACE TRIGGER ADAPTER.INT_FAC_FILT_TRG
BEFORE INSERT
ON ADAPTER.INT_FAC_FILT
FOR EACH ROW
BEGIN
    if :new.FAC_FILT_ID is null then
        :new.FAC_FILT_ID := ADAPTER.INT_FAC_FILT_SEQ.nextval;
    end if;
END INT_FAC_FILT_TRG;
/


ALTER TABLE ADAPTER.INT_FAC_FILT ADD (
  CONSTRAINT INT_FAC_FILT_PK
  PRIMARY KEY
  (FAC_FILT_ID)
  USING INDEX ADAPTER.INT_FAC_FILT_PK
  ENABLE VALIDATE);
