CREATE TABLE ADAPTER.INT_FACILITIES
(
  FACILITY_ID      NUMBER                       NOT NULL,
  FACILITY_NUMBER  VARCHAR2(255 BYTE),
  FACILITY_NAME    VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.INT_FAC_PK ON ADAPTER.INT_FACILITIES
(FACILITY_ID);

CREATE OR REPLACE TRIGGER ADAPTER.INT_FAC_TRG
BEFORE INSERT
ON ADAPTER.INT_FACILITIES
FOR EACH ROW
BEGIN
    if :new.FACILITY_ID is null then
        :new.FACILITY_ID := ADAPTER.INT_FAC_SEQ.nextval;
    end if;
END INT_FAC_TRG;
/


ALTER TABLE ADAPTER.INT_FACILITIES ADD (
  CONSTRAINT INT_FAC_PK
  PRIMARY KEY
  (FACILITY_ID)
  USING INDEX ADAPTER.INT_FAC_PK
  ENABLE VALIDATE);
