CREATE TABLE ADAPTER.FACILITY_SUPPORTED_TYPES
(
  FAC_SUP_ID    NUMBER                          NOT NULL,
  FACILITY_ID   NUMBER                          NOT NULL,
  VA_TYPE_ID    NUMBER                          NOT NULL,
  IS_PREF_TYPE  VARCHAR2(1 BYTE)                DEFAULT 'Y'                   NOT NULL
);


CREATE UNIQUE INDEX ADAPTER.FACILITY_SUPPORTED_TYPES_PK ON ADAPTER.FACILITY_SUPPORTED_TYPES
(FAC_SUP_ID);

CREATE OR REPLACE TRIGGER ADAPTER.FAC_SUP_TYPE_ID_TRG
BEFORE INSERT
ON ADAPTER.FACILITY_SUPPORTED_TYPES
FOR EACH ROW
BEGIN
    if :new.FAC_SUP_ID is null then
        :new.FAC_SUP_ID := ADAPTER.FACILITY_SUPPORTED_TYPES_SEQ.nextval;
    end if;
END FAC_SUP_TYPE_ID_TRG;
/


ALTER TABLE ADAPTER.FACILITY_SUPPORTED_TYPES ADD (
  CONSTRAINT FACILITY_SUPPORTED_TYPES_PK
  PRIMARY KEY
  (FAC_SUP_ID)
  USING INDEX ADAPTER.FACILITY_SUPPORTED_TYPES_PK
  ENABLE VALIDATE);
