CREATE TABLE ADAPTER.FACILITIES_TO_AAS
(
  FACILITY_TO_AA_ID       NUMBER,
  FACILITY_ID             NUMBER                NOT NULL,
  ASSIGNING_AUTHORITY_ID  NUMBER                NOT NULL
);


CREATE UNIQUE INDEX ADAPTER.FACILITIES_TO_AAS_UK1 ON ADAPTER.FACILITIES_TO_AAS
(FACILITY_ID, ASSIGNING_AUTHORITY_ID);

CREATE UNIQUE INDEX ADAPTER.FACILITIES_TO_ASSIGNING_AUT_PK ON ADAPTER.FACILITIES_TO_AAS
(FACILITY_TO_AA_ID);

CREATE OR REPLACE TRIGGER ADAPTER.FACILITY_TO_AA_ID_TRG 
BEFORE INSERT
ON ADAPTER.FACILITIES_TO_AAS 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
DECLARE
  N NUMBER;
BEGIN
    if :NEW.FACILITY_TO_AA_ID is null then
        select FACILITY_TO_AA_ID_SEQ.NEXTVAL into N from DUAL;
        :new.FACILITY_TO_AA_ID := N;
    end if;
end FACILITY_TO_AA_ID_TRG;
/


ALTER TABLE ADAPTER.FACILITIES_TO_AAS ADD (
  CONSTRAINT FACILITIES_TO_ASSIGNING_AUT_PK
  PRIMARY KEY
  (FACILITY_TO_AA_ID)
  USING INDEX ADAPTER.FACILITIES_TO_ASSIGNING_AUT_PK
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_TO_AAS ADD (
  CONSTRAINT FACILITIES_TO_AAS_UK1
  UNIQUE (FACILITY_ID, ASSIGNING_AUTHORITY_ID)
  USING INDEX ADAPTER.FACILITIES_TO_AAS_UK1
  ENABLE VALIDATE);
