CREATE TABLE ADAPTER.FACILITIES
(
  FACILITY_ID             NUMBER,
  FACILITY_NUMBER         VARCHAR2(10 BYTE)     NOT NULL,
  HOME_COMMUNITY_ID       VARCHAR2(255 BYTE)    NOT NULL,
  FACILITY_NAME           VARCHAR2(255 BYTE)    NOT NULL,
  FULL_HOME_COMMUNITY_ID  VARCHAR2(255 BYTE)    NOT NULL,
  ACP_CHECK               CHAR(1 BYTE),
  USE_SPEC_VERSION        VARCHAR2(5 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.FACILITIES_PK ON ADAPTER.FACILITIES
(FACILITY_ID);

CREATE INDEX ADAPTER.NDX_FACS_FULL_HOME_COM_ID ON ADAPTER.FACILITIES
(FULL_HOME_COMMUNITY_ID);

CREATE OR REPLACE TRIGGER ADAPTER.FACILITY_ID_TRG 
BEFORE INSERT
ON ADAPTER.FACILITIES 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.FACILITY_ID is null then
        select FACILITY_ID_SEQ.NEXTVAL into N from DUAL;
        :new.FACILITY_ID := N;
    end if;
end FACILITY_ID_TRG;
/


ALTER TABLE ADAPTER.FACILITIES ADD (
  CONSTRAINT FACILITIES_PK
  PRIMARY KEY
  (FACILITY_ID)
  USING INDEX ADAPTER.FACILITIES_PK
  ENABLE VALIDATE);
