CREATE TABLE ADAPTER.CODESETS
(
  CODESET_ID    NUMBER,
  CODESET       VARCHAR2(255 CHAR)              NOT NULL,
  LOOKUP_TABLE  VARCHAR2(255 CHAR)              NOT NULL,
  KEY_FIELD     VARCHAR2(255 CHAR)              NOT NULL
);


CREATE UNIQUE INDEX ADAPTER.CODESETS_PK ON ADAPTER.CODESETS
(CODESET_ID);

CREATE UNIQUE INDEX ADAPTER.CODESETS_UK1 ON ADAPTER.CODESETS
(CODESET);

ALTER TABLE ADAPTER.CODESETS ADD (
  CONSTRAINT CODESETS_PK
  PRIMARY KEY
  (CODESET_ID)
  USING INDEX ADAPTER.CODESETS_PK
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.CODESETS ADD (
  CONSTRAINT CODESET_UK1
  UNIQUE (CODESET)
  USING INDEX ADAPTER.CODESETS_UK1
  ENABLE VALIDATE);
