CREATE TABLE ADAPTER.CACHE
(
  CACHE_ID  NUMBER,
  HASH      VARCHAR2(255 BYTE)                  NOT NULL,
  DATA      BLOB
);


CREATE UNIQUE INDEX ADAPTER.CACHE_PK ON ADAPTER.CACHE
(CACHE_ID);

CREATE UNIQUE INDEX ADAPTER.CACHE_UK1 ON ADAPTER.CACHE
(HASH);

CREATE OR REPLACE TRIGGER ADAPTER.CACHE_ID_TRG 
BEFORE INSERT
ON ADAPTER.CACHE 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.CACHE_ID is null then
        select CACHE_ID_SEQ.NEXTVAL into N from DUAL;
        :new.CACHE_ID := N;
    end if;
end CACHE_ID_TRG;
/


ALTER TABLE ADAPTER.CACHE ADD (
  CONSTRAINT CACHE_PK
  PRIMARY KEY
  (CACHE_ID)
  USING INDEX ADAPTER.CACHE_PK
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.CACHE ADD (
  CONSTRAINT CACHE_UK1
  UNIQUE (HASH)
  USING INDEX ADAPTER.CACHE_UK1
  ENABLE VALIDATE);
