package gov.va.med.nhin.adapter.weblogic.concurrent;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

import commonj.work.Work;
import commonj.work.WorkManager;

/**
 *
 *1/6/2017
 * created new for the use for Patient Discovery
 */
public class WorkManagerExecutorService extends AbstractExecutorService
{
	private WorkManager workManager;

	public void setWorkManager(WorkManager workManager)
	{
		this.workManager = workManager;
	}

	public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public boolean isShutdown()
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public boolean isTerminated()
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public void shutdown()
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public List<Runnable> shutdownNow()
	{
		throw new UnsupportedOperationException("Not supported yet.");
	}

	public void execute(final Runnable command)
	{
		if(command == null)
		{
			throw new NullPointerException();
		}

		if(workManager == null)
		{
			throw new RejectedExecutionException("A workManager must be set.");
		}

		try
		{
			workManager.schedule(new Work()
			{
				public boolean isDaemon()
				{
					return false;
				}

				public void release()
				{
				}

				public void run()
				{
					command.run();
				}
			});
		}
		catch(Exception e)
		{
			throw new RejectedExecutionException(e);
		}
	}
}
