
package org.hl7.v3;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 *             An identifier that uniquely identifies a thing or object.
 *             Examples are object identifier for HL7 RIM objects,
 *             medical record number, order id, service catalog item id,
 *             Vehicle Identification Number (VIN), etc. Instance
 *             identifiers are defined based on ISO object identifiers.
 *          
 * 
 * <p>Java class for II complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="II">
 *   &lt;complexContent>
 *     &lt;extension base="{urn:hl7-org:v3}ANY">
 *       &lt;attribute name="root" type="{urn:hl7-org:v3}uid" />
 *       &lt;attribute name="extension" type="{urn:hl7-org:v3}st" />
 *       &lt;attribute name="assigningAuthorityName" type="{urn:hl7-org:v3}st" />
 *       &lt;attribute name="displayable" type="{urn:hl7-org:v3}bl" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "II")
@XmlSeeAlso({
    PRPAMT201302UV02NonPersonLivingSubjectId.class,
    PRPAMT201302UV02GuardianId.class,
    PRPAMT201302UV02MemberId.class,
    PRPAMT201302UV02EmployeeId.class,
    PRPAMT201302UV02CareGiverId.class,
    PRPAMT201302UV02OtherIDsId.class,
    PRPAMT201302UV02StudentId.class,
    PRPAMT201302UV02PersonalRelationshipId.class,
    POCDMT000040InfrastructureRootTypeId.class,
    PRPAMT201302UV02PersonId.class,
    PRPAMT201302UV02AdministrativeObservationId.class,
    PRPAMT201302UV02CitizenId.class,
    PRPAMT201302UV02PatientId.class,
    PRPAMT201302UV02ContactPartyId.class
})
public class II
    extends ANY
{

    @XmlAttribute(name = "root")
    protected String root;
    @XmlAttribute(name = "extension")
    protected String extension;
    @XmlAttribute(name = "assigningAuthorityName")
    protected String assigningAuthorityName;
    @XmlAttribute(name = "displayable")
    protected Boolean displayable;

    /**
     * Gets the value of the root property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRoot() {
        return root;
    }

    /**
     * Sets the value of the root property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRoot(String value) {
        this.root = value;
    }

    /**
     * Gets the value of the extension property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getExtension() {
        return extension;
    }

    /**
     * Sets the value of the extension property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExtension(String value) {
        this.extension = value;
    }

    /**
     * Gets the value of the assigningAuthorityName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAssigningAuthorityName() {
        return assigningAuthorityName;
    }

    /**
     * Sets the value of the assigningAuthorityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssigningAuthorityName(String value) {
        this.assigningAuthorityName = value;
    }

    /**
     * Gets the value of the displayable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDisplayable() {
        return displayable;
    }

    /**
     * Sets the value of the displayable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDisplayable(Boolean value) {
        this.displayable = value;
    }

}
