
package gov.va.med.nhin.adapter.audit;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ActionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ActionType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Retrieve Document"/>
 *     &lt;enumeration value="RetrieveDocumentOut"/>
 *     &lt;enumeration value="PatientDiscoveryOut"/>
 *     &lt;enumeration value="AddPatientCorrelation"/>
 *     &lt;enumeration value="CPP OptOut"/>
 *     &lt;enumeration value="CPP Announce"/>
 *     &lt;enumeration value="Announce"/>
 *     &lt;enumeration value="CheckPolicy"/>
 *     &lt;enumeration value="MPI findMatch"/>
 *     &lt;enumeration value="CPP OptIn"/>
 *     &lt;enumeration value="CPP Login"/>
 *     &lt;enumeration value="CPP Revoke"/>
 *     &lt;enumeration value="DocumentSubmissionIn"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "ActionType")
@XmlEnum
public enum ActionType {

    @XmlEnumValue("Retrieve Document")
    RETRIEVE_DOCUMENT("Retrieve Document"),
    @XmlEnumValue("RetrieveDocumentOut")
    RETRIEVE_DOCUMENT_OUT("RetrieveDocumentOut"),
    @XmlEnumValue("PatientDiscoveryOut")
    PATIENT_DISCOVERY_OUT("PatientDiscoveryOut"),
    @XmlEnumValue("AddPatientCorrelation")
    ADD_PATIENT_CORRELATION("AddPatientCorrelation"),
    @XmlEnumValue("CPP OptOut")
    CPP_OPT_OUT("CPP OptOut"),
    @XmlEnumValue("CPP Announce")
    CPP_ANNOUNCE("CPP Announce"),
    @XmlEnumValue("Announce")
    ANNOUNCE("Announce"),
    @XmlEnumValue("CheckPolicy")
    CHECK_POLICY("CheckPolicy"),
    @XmlEnumValue("MPI findMatch")
    MPI_FIND_MATCH("MPI findMatch"),
    @XmlEnumValue("CPP OptIn")
    CPP_OPT_IN("CPP OptIn"),
    @XmlEnumValue("CPP Login")
    CPP_LOGIN("CPP Login"),
    @XmlEnumValue("CPP Revoke")
    CPP_REVOKE("CPP Revoke"),
    @XmlEnumValue("DocumentSubmissionIn")
    DOCUMENT_SUBMISSION_IN("DocumentSubmissionIn");
    private final String value;

    ActionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ActionType fromValue(String v) {
        for (ActionType c: ActionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
