package gov.va.med.nhin.adapter.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import gov.va.med.nhin.adapter.datamanager.parsers.VitalsPostProcessingDataParser;
import gov.va.med.nhin.adapter.results.MeasurementType;
import gov.va.med.nhin.adapter.results.ResultsType;
import gov.va.med.nhin.adapter.results.VitalType;
import gov.va.med.nhin.adapter.results.VitalType.Measurements;
import gov.va.med.nhin.adapter.results.VitalsType;
import gov.va.med.nhin.adapter.utils.XMLUtils;

public class VitalsPostProcessingParserTest {
	
	private List<Serializable> vitalsList = new ArrayList<>();
	
	@Before
	public void setUp() throws Exception
	{
		//VitalType vt = new VitalType();
		//vt.setMeasurements(getTestMeasurements());
		//vitalsList.add(vt);
		vitalsList = getVitalsList();
	}

	@SuppressWarnings("unchecked")
	@Test
	public void testParse()
	{
		VitalsPostProcessingDataParser parser = new VitalsPostProcessingDataParser();
		
		VitalsType vt = (VitalsType)vitalsList.get(0);
		List<VitalType> list = parser.parse(vt.getVital(), null, null);
		
		assert(!list.isEmpty());
	}

	private VitalType.Measurements getTestMeasurements()
	{
		VitalType.Measurements ms = new Measurements();
		MeasurementType mt = new MeasurementType();
		mt.setVuid("4500634");
		mt.setValue("130/68");
		mt.setUnit("mm[Hg]");
		mt.setName("BLOOD PRESSURE");
		
		ms.getMeasurement().add(mt);
		
		MeasurementType mt2 = new MeasurementType();
		mt2.setVuid("4500634");
		mt2.setValue("160/");
		mt2.setUnit("mm[Hg]");
		mt2.setName("BLOOD PRESSURE");
		ms.getMeasurement().add(mt2);

		MeasurementType mt3 = new MeasurementType();
		mt3.setVuid("4500634");
		mt3.setValue("/78");
		mt3.setUnit("mm[Hg]");
		mt3.setName("BLOOD PRESSURE");
		ms.getMeasurement().add(mt3);

		MeasurementType mt4 = new MeasurementType();
		mt4.setVuid("4500639");
		mt4.setBmi("65*");
		mt4.setValue("230");
		mt4.setUnit("lb");
		mt4.setName("WEIGHT");
		ms.getMeasurement().add(mt4);
		
		

		return ms;

	}
	
	private List<Serializable> getVitalsList()
	{
		ResultsType rt = null;
		try
		{
			rt = XMLUtils.load("src/test/resources/VistA.findVitals2.xml", ResultsType.class);
		}
		catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return rt.getResults();
	}
}
