/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author ryan
 */
public class DataQueryImplTest {

	public static final String CONFIG_DIR
			= "../weblogic/domains/ehx_devl/config/adapter";
	public static final String RESULTS_DIR = "src/test/resources";

	private static final String DM_CONFIG = CONFIG_DIR + "/dataManagerConfig.xml";

	private static final Logger log = LoggerFactory.getLogger( DataQueryImplTest.class );

	private final DataManagerImpl manager;

	public DataQueryImplTest() throws Exception {
		System.setProperty( "org.owasp.esapi.resources", CONFIG_DIR );
		manager = new DataManagerImpl( DM_CONFIG );
		manager.setDataAdapter( "VistALink", new FileBasedVistA() );
		manager.setTranslationDef( "STSTranslate", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		manager.setTranslationDef( "STSLookup", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		manager.setTranslationDef( "Lookup", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		manager.setTranslationDef( "Translate", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
	}

	@BeforeClass
	public static void setUpClass() {
	}

	@AfterClass
	public static void tearDownClass() {
	}

	@Before
	public void setUp() {
	}

	@After
	public void tearDown() {
	}

	private static void assertEquivalent( Object obj, String testfile ) {
		try ( StringWriter sw = new StringWriter() ) {
			ObjectMapper om = new ObjectMapper();

			ObjectWriter ow = om.writerWithDefaultPrettyPrinter();
			ow.writeValue( sw, obj );

			String actual = sw.toString();
			// it's sometimes handy to save files like this afterwards
			// FIXME: logger is never debug-enabled?
			//if ( log.isDebugEnabled() ) {
			Path trace = Files.createTempFile( "unit-tests-" + testfile + "-", ".xml" );
			FileUtils.write( trace.toFile(), actual, "utf-8" );
			//}

			String expected = FileUtils.readFileToString( new File( RESULTS_DIR,
					testfile ), "utf-8" );
			assertEquals( expected, actual );
		}
		catch ( Exception e ) {
			fail( e.getMessage() );
		}
	}

	@Test
	public void testVitals() {
		DataQuery instance = manager.getQuery( "VistA.findVitals2" );
		List result = instance.getResults();
		assertEquivalent( result, "results.vitals" );
	}

	//@Test
	public void testReactionsProblemsImmunizationsHealthFactors() {
		DataQuery instance = manager.getQuery( "VistA.findAllergiesAndProblemsAndImmunizationsAndHealthFactors" );
		List result = instance.getResults();
		/**
		 * TODO : these types of comparisons (serializing to a string) has weird
		 * quirks and fails at times when it shouldn't Fix and then re-enable
		 */
		assertEquivalent( result, "results.reactionsproblemsimmunizationshealthfactors" );
	}

	@Test
	public void testDemographics() {
		DataQuery instance = manager.getQuery( "VistA.findDemographics2" );
		List result = instance.getResults();
		assertEquivalent( result, "results.demographics" );
	}

	@Test
	public void testDischarge() {
		DataQuery instance = manager.getQuery( "VistA.findDischargeSummary" );
		List result = instance.getResults();
		assertEquivalent( result, "results.discharge" );
	}

	//@Test
	public void testRadiologyAndPathology() {
		DataQuery instance = manager.getQuery( "VistA.findRadiologiesAndPathologies" );
		List result = instance.getResults();
		/**
		 * TODO : these types of comparisons (serializing to a string) has weird
		 * quirks and fails at times when it shouldn't Fix and then re-enable
		 */
		assertEquivalent( result, "results.radandpath" );
	}

	@Test
	public void testCRDocuments() {
		DataQuery instance = manager.getQuery( "VistA.findConsultNotes3" );
		instance.setParameter( "$XDSDocumentEntryPatientId", "junk1" );
		instance.setParameter( "$XDSDocumentEntryStatus", "junk2" );
		List result = instance.getResults();
		assertEquivalent( result, "results.crdocs" );
	}

	@Test
	public void testHPNDocuments() {
		DataQuery instance = manager.getQuery( "VistA.findHistoryAndPhysicalNotes" );
		instance.setParameter( "$XDSDocumentEntryPatientId", "junk1" );
		instance.setParameter( "$XDSDocumentEntryStatus", "junk2" );
		List result = instance.getResults();
		assertEquivalent( result, "results.hpndocs" );
	}
}
