package gov.va.med.nhin.adapter.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXB;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;

import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

import gov.va.med.nhin.adapter.xmlutils.XMLParserUtils;

/**
 *
 * @author David Vazquez
 */
public class XMLUtils
{
    static public boolean isAttributeSet(Node property, String name)
    {
        Node attr = property.getAttributes().getNamedItem(name);
        return attr != null && attr.getTextContent().equalsIgnoreCase("true");
    }

    static public Document parse(String filename) throws Exception
    {
        DocumentBuilder db = XMLParserUtils.getXMLDocBuilder();
        db.setEntityResolver(getEntityResolver());
        InputStream ret = Utils.getResourceAsStream(filename);
        Document document = null;
        try {
            document = db.parse(ret);
        }
        finally {
            if (ret != null) {
                ret.close();
            }
        }

        return document;
    }

    static public <T extends Object> T load(String filename, Class<T> cls) throws Exception
    {
        InputStream ret = Utils.getResourceAsStream(filename);

        try {
            return load(ret, cls);
        }
        finally {
            if (ret != null) {
                ret.close();
            }
        }
    }

    static public <T extends Object> T load(InputStream in, Class<T> cls) throws Exception
    {
        DocumentBuilder db = XMLParserUtils.getXMLDocBuilder();
        db.setEntityResolver(getEntityResolver());

        byte[] bytes = IOUtils.toByteArray(in);
        // System.out.println("--- Starting byte sequence. ---");
        String stream = new String(bytes, StandardCharsets.ISO_8859_1);
        bytes = stream.getBytes(StandardCharsets.UTF_8);
        // System.out.println(DatatypeConverter.printHexBinary(bytes));
        // System.out.println("--- Ending byte sequence. ---");
        Document doc = db.parse(new ByteArrayInputStream(bytes));

        DOMSource source = new DOMSource(doc);

        return JAXB.unmarshal(source, cls);
    }

    static public void save(String filename, Object obj) throws Exception
    {
        URL url = Utils.getResource(filename);
        File f = new File(url.getPath());
        JAXB.marshal(obj, f);
    }

    static public EntityResolver getEntityResolver()
    {
        return new EntityResolver()
        {
            public InputSource resolveEntity(String publicId, String systemId) throws IOException
            {
                if (publicId != null) {
                    return new InputSource();
                }
                else {
                    InputStream is = null;
                    try {
                        is = Utils.getResourceAsStream(systemId);
                        return new InputSource(is);
                    }
                    catch (Throwable e) {
                        return new InputSource();
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
        };
    }
}
