package gov.va.med.nhin.adapter.utils;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * @author alok.subedi
 */
public class AuditUtil {

    /*
    * We will change this list as we know what systemId values we are going to receive.
    * System Ids are captured from the Name element from Org slot, that is a child slot of UserInfo. 
    */
    private static final ArrayList<String> systems = new ArrayList<String>(Arrays.asList("JLV", "eHMP", "DAS", "vistaWeb"));

    public static String checkSystemId(AssertionType assertion) {
        String systemId = "UNKNOWN";
        if (NullChecker.isNotNullOrEmpty(assertion.getUserInfo().getOrg().getName())) {
            if (systems.contains(assertion.getUserInfo().getOrg().getName())) {
                systemId = assertion.getUserInfo().getOrg().getName();
            }
        }
        return systemId;
    }
}
