/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging;

/**
 * A class to simplify and standardize certain messaging-specific events
 *
 * @param <T> the type of audit class to use
 */
public interface MessagingHelper<T> {
	static final String PARTNER = "partner";
	static final String REQUEST = "request";


	/**
	 * Gets a partner authorization event
	 *
	 * @param evt the type of partner authorization
	 * @param source who's doing the logging
	 * @param partner the partner in question
	 * @return the event to be logged
	 */
	public T partnerauth( LogConstants.AuditingEvent evt, Class<?> source,
			String partner );

	/**
	 * Gets a request/response event.
	 *
	 * @param evt the type of request/response
	 * @param source who's doing the logging
	 * @param partner the partner doing the work
	 * @return the event to be logged
	 */
	public T reqres( LogConstants.AuditingEvent evt, Class<?> source,
			String partner );
}
