/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging;

import javax.xml.namespace.QName;
import org.hl7.fhir.dstu3.model.Coding;

/**
 * Provides some constants to standardize logging. At the moment, this is just
 * some keys for handling transaction ids for the {@link org.slf4j.MDC}
 *
 * @author ryan
 */
public final class LogConstants {

	public static final String CORRELATION_MDCKEY = "correlationId";
	public static final QName CORRELATION_SOAPPROP
			= new QName( "http://connectopensource.org/transaction/", "TransactionID", "txn" );

	private static final String MESSAGING = "messaging";
	private static final String SYSTEM_URIBASE = "http://gov/va/med/nhin/adapter/";
	private static final Coding DCM_QUERY
			= new Coding( "http://dicom.nema.org/resources/ontology/DCM", "110112", "Query" );

	public static final String MESSAGING_URI = SYSTEM_URIBASE + MESSAGING;

	public static enum AuditingEvent {
		/**
		 * General logging
		 */
		INFO( MESSAGING, "", MESSAGING_URI, DCM_QUERY, "Informational", "Informational" ),
		/**
		 * PD constants
		 */
		PDIN_BEGIN( MESSAGING, "pd.in", MESSAGING_URI, DCM_QUERY, "PD IN Begin", "Patient Discovery Inbound begin" ),
		PDIN_END( MESSAGING, "pd.in", MESSAGING_URI, DCM_QUERY, "PD IN End", "Patient Discovery Inbound end" ),
		PDIN_PARTNERAUTH( MESSAGING, "pd.in", MESSAGING_URI, DCM_QUERY, "PD IN partner auth", "Patient Discovery Inbound Partner Authorized" ),
		PDIN_PATIENTMATCH( MESSAGING, "pd.in", MESSAGING_URI, DCM_QUERY, "PD IN patient match", "Patient Discovery Inbound Patient Match" ),
		PDIN_PATIENTSHARE( MESSAGING, "pd.in", MESSAGING_URI, DCM_QUERY, "PD IN patient share", "Patient Discovery Inbound Patient Share OK" ),
		PDIN_CORRELATESTORED( MESSAGING, "pd.in", MESSAGING_URI, DCM_QUERY, "PD IN cor", "Patient Discovery Inbound Correlation Stored" ),
		PDOUT_BEGIN( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT Begin", "Patient Discovery Outbound begin" ),
		PDOUT_END( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT End", "Patient Discovery Outbound end" ),
		PDOUT_GETPARTNERS( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT get partners", "Patient Discovery Outbound Get Partners from UDDI" ),
		PDOUT_PARTNERAUTH( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT partner auth", "Patient Discovery Outbound Partner Authorized" ),
		PDOUT_PD( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT pd", "Patient Discovery Outbound Patient Patient Discovery" ),
		PDOUT_VALIDMATCH( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT validate match", "Patient Discovery Outbound Validate Match" ),
		PDOUT_CORRELATESTORED( MESSAGING, "pd.out", MESSAGING_URI, DCM_QUERY, "PD OUT cor", "Patient Discovery Outbound Correlation Stored" ),
		/**
		 * QD constants
		 */
		QDIN_BEGIN( MESSAGING, "qd.in", MESSAGING_URI, DCM_QUERY, "QD IN Begin", "Query Documents Inbound begin" ),
		QDIN_END( MESSAGING, "qd.in", MESSAGING_URI, DCM_QUERY, "QD IN End", "Query Documents Inbound end" ),
		QDIN_PARTNERAUTH( MESSAGING, "qd.in", MESSAGING_URI, DCM_QUERY, "QD IN partner auth", "Query Documents Inbound Partner Authorized" ),
		QDIN_PATIENTSHARE( MESSAGING, "qd.in", MESSAGING_URI, DCM_QUERY, "QD IN patient share", "Query Documents Inbound Patient Share OK" ),
		QDIN_GATHER( MESSAGING, "qd.in", MESSAGING_URI, DCM_QUERY, "QD IN gather", "Query Documents Inbound Data Gathered/Document Generation" ),
		QDOUT_BEGIN( MESSAGING, "qd.out", MESSAGING_URI, DCM_QUERY, "QD OUT Begin", "Query Documents Outbound begin" ),
		QDOUT_END( MESSAGING, "qd.out", MESSAGING_URI, DCM_QUERY, "QD OUT End", "Query Documents Outbound end" ),
		QDOUT_GETPARTNERS( MESSAGING, "qd.out", MESSAGING_URI, DCM_QUERY, "QD OUT get correlations", "Query Documents Outbound Get Correlations from MVI" ),
		QDOUT_PARTNERAUTH( MESSAGING, "qd.out", MESSAGING_URI, DCM_QUERY, "QD OUT partner auth", "Query Documents Outbound Partner Authorized" ),
		QDOUT_QD( MESSAGING, "qd.out", MESSAGING_URI, DCM_QUERY, "QD OUT qd", "Query Documents Outbound Patient Query Documents" ),
		/**
		 * RD constants
		 */
		RDIN_BEGIN( MESSAGING, "rd.in", MESSAGING_URI, DCM_QUERY, "RD IN Begin", "Retrieve Document Inbound begin" ),
		RDIN_END( MESSAGING, "rd.in", MESSAGING_URI, DCM_QUERY, "RD IN End", "Retrieve Document Inbound end" ),
		RDIN_PARTNERAUTH( MESSAGING, "rd.in", MESSAGING_URI, DCM_QUERY, "RD IN partner auth", "Retrieve Document Inbound Partner Authorized" ),
		RDIN_DISCLOSEOK( MESSAGING, "rd.in", MESSAGING_URI, DCM_QUERY, "RD IN disclosure ok", "Retrieve Document Inbound Disclosure OK" ),
		RDIN_GATHER( MESSAGING, "rd.in", MESSAGING_URI, DCM_QUERY, "RD IN gather", "Retrieve Document Inbound Data Gathered/Document Generation" ),
		RDOUT_BEGIN( MESSAGING, "rd.out", MESSAGING_URI, DCM_QUERY, "RD OUT Begin", "Retrieve Document Outbound begin" ),
		RDOUT_END( MESSAGING, "rd.out", MESSAGING_URI, DCM_QUERY, "RD OUT End", "Retrieve Document Outbound end" ),
		RDOUT_PARTNERAUTH( MESSAGING, "rd.out", MESSAGING_URI, DCM_QUERY, "RD OUT partner auth", "Retrieve Document Outbound Partner Authorized" ),
		RDOUT_RD( MESSAGING, "rd.out", MESSAGING_URI, DCM_QUERY, "RD OUT rd", "Retrieve Document Outbound Patient Retrieve Document" ),
		/**
		 * Submit constants
		 */
		SUBMITIN_BEGIN( MESSAGING, "submit.in", MESSAGING_URI, DCM_QUERY, "SUB IN Begin", "Submit Document Inbound begin" ),
		SUBMITIN_END( MESSAGING, "submit.in", MESSAGING_URI, DCM_QUERY, "SUB IN End", "Submit Document Inbound end" ),
		SUBMITIN_PARTNERAUTH( MESSAGING, "submit.in", MESSAGING_URI, DCM_QUERY, "SUB IN partner auth", "Submit Document Inbound Partner Authorized" ),
		SUBMITIN_STORE( MESSAGING, "submit.in", MESSAGING_URI, DCM_QUERY, "SUB IN patient share", "Submit Document Inbound Patient Store" );

		public final Coding coding;
		public final String category;
		public final Coding type;

		AuditingEvent( String cat, String subcat, String systemuri, Coding maintype,
				String codename, String desc ) {
			category = cat + "." + subcat;
			coding = new Coding( systemuri, codename, desc );
			type = maintype;
		}

		public static AuditingEvent fromCode( String codename ) {
			for ( AuditingEvent ae : values() ) {
				if ( ae.coding.getCode().equals( codename ) ) {
					return ae;
				}
			}

			throw new IllegalArgumentException( "unknown code: " + codename );
		}
	}
}
