package gov.va.med.nhin.adapter.datamanager.translators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;

public class NotFilterDataTranslator implements DataTranslator<List<Object>>
{
	private static final Logger logger = LoggerFactory.getLogger(NotFilterDataTranslator.class.getName());

	@Override
	public List<Object> translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		List<Object> ret = null;
		String whereProperty = translation.getProperty("whereProperty");
		String wherePropertyValue = translation.getProperty("wherePropertyValue");

		logger.debug("whereProperty={}", whereProperty);
		logger.debug("wherePropertyValue={}", wherePropertyValue);

		logger.debug("input={}", input.toString());
		logger.debug("input class={}", input.getClass());

		try
		{
			if(input != null)
			{
				if(!Utils.isCollection(input))
				{
					if(input instanceof SmartHashMap)
					{
						List<Object> objList = new ArrayList<>();

						Object value = PropertyUtils.getProperty(input, whereProperty);
						logger.debug("value={}", value);
						if(NullChecker.isNullOrEmpty(value) || !value.equals(wherePropertyValue))
						{
							objList.add(input);
						}

						return objList;
					}
					else
					{
						throw new RuntimeException("input must be a collection.");
					}
				}

				List<Object> objList = new ArrayList<>();
				for(int i = 0; i < Utils.getCollectionLength(input); ++i)
				{
					Object obj = PropertyUtils.getIndexedProperty(input, "", i);
					Object value = PropertyUtils.getProperty(obj, whereProperty);
					logger.debug("value={}", value);
					if(NullChecker.isNullOrEmpty(value) || !value.equals(wherePropertyValue))
					{
						objList.add(obj);
					}
				}

				ret = objList;
			}
		}
		catch(RuntimeException | IllegalAccessException | InvocationTargetException | NoSuchMethodException t)
		{
			throw new DataManagerException("There was an error.", t);
		}

		return ret;
	}
}
