package gov.va.med.nhin.adapter.datamanager.translators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class InstringDataTranslator implements DataTranslator<String>
{
	private static final Logger logger = LoggerFactory.getLogger(InstringDataTranslator.class.getName());

	@Override
	public String translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
	{
		String ret = null;

		if(input != null)
		{
			if(!(input instanceof String))
			{
				// throw new DataManagerException("input must be of type
				// java.lang.String.");

				try
				{
					input = input.toString();
				}
				catch(Exception e)
				{
					logger.error("Input Not String Type. Ex: {}", e.getMessage());
					logger.error("Input Type: {}", input.getClass());
					logger.error("Input toString -> {}", input.toString());
					ret = "";
					return ret;
				}
			}

			String delimiter = translationType.getProperty("delimiter");
			String index = translationType.getProperty("index");

			String[] parts = ((String) input).split(delimiter);

			if(parts.length > 0)
			{
				if(index.equals("last"))
				{
					ret = parts[parts.length - 1];
				}
				else if(index.equals("notLast"))
				{
					StringBuilder buffer = new StringBuilder();
					for(int i = 0; i < parts.length - 1; ++i)
					{
						if(buffer.length() > 0)
						{
							buffer.append(delimiter);
						}
						buffer.append(parts[i]);
					}
					ret = buffer.toString();
				}
				else
				{
					int i = Integer.parseInt(index);

					if(i < parts.length)
					{
						ret = parts[i];
					}
					else
					{
						ret = parts[0];
					}
				}
			}
			else
			{
				ret = "";
			}
		}

		return ret;
	}
}
