package gov.va.med.nhin.adapter.datamanager.translators;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.results.ExposuresType;
import gov.va.med.nhin.adapter.utils.Utils;

public class ExposureCompilationDataTranslator implements DataTranslator<ExposuresType>
{
	private static final Logger logger = LoggerFactory.getLogger(ExposureCompilationDataTranslator.class.getName());

	@Override
	public ExposuresType translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		ExposuresType ret = null;

		// Default exposures to 0
		ExposuresType expType = new ExposuresType();
		expType.setAo("0");
		expType.setCv("0");
		expType.setHnc("0");
		expType.setMst("0");
		expType.setPgulf("0");
		expType.setRad("0");

		try
		{
			if(input != null)
			{
				logger.debug("input={}", input.toString());
				logger.debug("input class={}", input.getClass());

				if(!Utils.isCollection(input))
				{
					if(input instanceof SmartHashMap)
					{
						Object value = PropertyUtils.getProperty(input, "value");
						logger.debug("value={}", value);

						if(value.equals("AO"))
						{
							expType.setAo("1");
						}
						else if(value.equals("CV"))
						{
							expType.setCv("1");
						}
						else if(value.equals("HNC"))
						{
							expType.setHnc("1");
						}
						else if(value.equals("MST"))
						{
							expType.setMst("1");
						}
						else if(value.equals("PG"))
						{
							expType.setPgulf("1");
						}
						else if(value.equals("IR"))
						{
							expType.setRad("1");
						}

						ret = expType;
						return ret;
					}
					else
					{
						throw new RuntimeException("Input must be a collection.");
					}
				}

				for(int i = 0; i < Utils.getCollectionLength(input); ++i)
				{
					Object obj = PropertyUtils.getIndexedProperty(input, "", i);
					Object value = PropertyUtils.getProperty(obj, "value");
					logger.debug("value={}", value);

					if(value.equals("AO"))
					{
						expType.setAo("1");
					}
					else if(value.equals("CV"))
					{
						expType.setCv("1");
					}
					else if(value.equals("HNC"))
					{
						expType.setHnc("1");
					}
					else if(value.equals("MST"))
					{
						expType.setMst("1");
					}
					else if(value.equals("PG"))
					{
						expType.setPgulf("1");
					}
					else if(value.equals("IR"))
					{
						expType.setRad("1");
					}
				}
			}
			ret = expType;
		}
		catch(RuntimeException | IllegalAccessException | InvocationTargetException | NoSuchMethodException t)
		{
			throw new DataManagerException("There was an error.", t);
		}

		return ret;
	}
}
