package gov.va.med.nhin.adapter.datamanager.translators;

import org.apache.commons.codec.binary.Base64;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.io.UnsupportedEncodingException;

/**
 *
 * @author David Vazquez
 */
public class Base64EncodeDataTranslator implements DataTranslator<String>
{
	@Override
	public String translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String ret = null;

		if(NullChecker.isNotNullOrEmpty(input))
		{
			if(!(input instanceof String))
			{
				throw new DataManagerException("input must be of type java.lang.String.");
			}

			byte[] inputAsBytes;
			try
			{
				inputAsBytes = ((String) input).getBytes("UTF-8");
			}
			catch(UnsupportedEncodingException ex)
			{
				throw new DataManagerException("Failed to convert to UTF-8 prior to encoding value. " + ex.getLocalizedMessage());
			}
			ret = Base64.encodeBase64String(inputAsBytes);
		}

		return ret;
	}
}
