package gov.va.med.nhin.adapter.datamanager.translators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataDate;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.utils.Utils;

public class AssessmentDateAddDataTranslator implements DataTranslator<List<Object>>
{
	@Override
	public List<Object> translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		List<Object> ret = null;
		String admittedName = translation.getProperty("admittedDate");
		String dischargedName = translation.getProperty("dischargedDate");
		DataDate admitted = (DataDate) translation.getValue(admittedName);
		DataDate discharged = (DataDate) translation.getValue(dischargedName);
		DataDate admittedRaw = (DataDate) translation.getValue("admitted");
		DataDate dischargedRaw = (DataDate) translation.getValue("discharged");

		try
		{
			if(input != null)
			{
				if(!Utils.isCollection(input))
				{

					if(input instanceof SmartHashMap)
					{
						List<Object> objList = new ArrayList<>();

						String type = (String) PropertyUtils.getProperty(input, "assessmentType");

						if(type.equalsIgnoreCase("admission") || type.equalsIgnoreCase("goals") || type.equalsIgnoreCase("interim"))
						{
							PropertyUtils.setProperty(input, "assessmentDate", admitted);
							PropertyUtils.setProperty(input, "assessmentDateRaw", admittedRaw);
						}
						else
						{
							PropertyUtils.setProperty(input, "assessmentDate", discharged);
							PropertyUtils.setProperty(input, "assessmentDateRaw", dischargedRaw);
						}

						objList.add(input);

						return objList;
					}
					else
					{
						throw new RuntimeException("input must be a collection.");
					}
				}

				List<Object> objList = new ArrayList<>();
				for(int i = 0; i < Utils.getCollectionLength(input); i++)
				{
					Object obj = PropertyUtils.getIndexedProperty(input, "", i);
					String type = (String) PropertyUtils.getProperty(obj, "assessmentType");

					if(type.equalsIgnoreCase("admission") || type.equalsIgnoreCase("goals") || type.equalsIgnoreCase("interim"))
					{
						PropertyUtils.setProperty(obj, "assessmentDate", admitted);
					}
					else
					{
						PropertyUtils.setProperty(obj, "assessmentDate", discharged);
					}

					objList.add(obj);
				}

				ret = objList;
			}
		}
		catch(RuntimeException | IllegalAccessException | InvocationTargetException | NoSuchMethodException t)
		{
			throw new DataManagerException("There was an error.", t);
		}

		return ret;
	}
}
