package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;

/**
 * @author vhaiswchmarc
 *
 */
public class AdditionalDocumentContent implements DataTranslator
{
	@SuppressWarnings("unchecked")
	@Override
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Object ret = null;
		if(input != null)
		{
			if(input instanceof List)
			{
				List<Object> retDocs = new ArrayList<>();
				List<Object> documents = (List<Object>) input;
				for(Object obj : documents)
				{
					Object document = getDocument(obj, dataQuery);
					if(document != null)
					{
						retDocs.add(document);
					}
				}
				if(CollectionUtils.isNotEmpty(retDocs))
				{
					return retDocs;
				}
			}
			else
			{
				return getDocument(input, dataQuery);
			}
		}

		return ret;
	}

	@SuppressWarnings("unchecked")
	private SmartHashMap getDocument(Object input, DataQuery dataQuery)
	{
		if(input instanceof SmartHashMap)
		{
			String id = (String) ((SmartHashMap) input).get("id");
			if(StringUtils.isNotBlank(id))
			{
				DataQuery dq = dataQuery.getDataManager().getQuery("VistA.findAllDocuments");
				dq.setProperty("connection", dataQuery.getProperty("connection"));
				dq.setParameter("dfn", dataQuery.getParameter("dfn"));
				dq.setParameter("id", id);
				List<Object> results = dq.getResults();
				if(CollectionUtils.isNotEmpty(results))
				{
					// We are only expecting one result
					Object result = results.get(0);
					if(result instanceof SmartHashMap)
					{
						SmartHashMap value = (SmartHashMap) result;
						if(!value.isEmpty())
						{
							return value;
						}
					}
				}
			}
		}
		return null;
	}
}
