package gov.va.med.nhin.adapter.datamanager.parsers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Document;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataParser;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplate;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplateFactory;

/**
 *
 * @author David Vazquez
 */
public class XMLTemplateDataParser implements DataParser
{
	public List parse(List dataResults, Reference parser, DataQuery dataQuery)
	{
		List ret = new ArrayList<Map>();
		String configFilename = parser.getProperty("configFilename");
		String metaDataFields = parser.getProperty("metaDataFields");
		XMLTemplate xmlTemplate = XMLTemplateFactory.getXMLTemplate(configFilename);

		for(Object dataResult : dataResults)
		{
			Map result = new HashMap();
			Document document = xmlTemplate.fillIn(dataResult);
			result.put("document", document);

			if(!NullChecker.isNullOrEmpty(metaDataFields))
			{
				for(String metaDataField : metaDataFields.split(","))
				{
					try
					{
						result.put(metaDataField, PropertyUtils.getProperty(dataResult, metaDataField));
					}
					// CCR1779231
					catch(IllegalAccessException | InvocationTargetException | NoSuchMethodException e)
					{
						throw new DataManagerException("Error getting returnProperty from unmarshalled xml object.", e);
					}
				}
			}

			ret.add(result);
		}

		return ret;
	}
}
