package gov.va.med.nhin.adapter.datamanager.parsers;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.nhin.adapter.datamanager.DataParser;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.results.MeasurementType;
import gov.va.med.nhin.adapter.results.VitalType;

/**
 *
 * @author David Vazquez
 */
public class VitalsPostProcessingDataParser implements DataParser
{
	static private final String VUID_BLOOD_PRESSURE = "4500634";
	static private final String VUID_BLOOD_PRESSURE_ORIG = "~-1";
	static private final String VUID_BLOOD_PRESSURE_SYSTOLIC = "~1";
	static private final String VUID_BLOOD_PRESSURE_DIASTOLIC = "~2";
	static private final String VUID_BLOOD_PRESSURE_MEAN = "~3";
	static private final String NAME_BLOOD_PRESSURE_SYSTOLIC = "SYSTOLIC";
	static private final String NAME_BLOOD_PRESSURE_DIASTOLIC = "DIASTOLIC";
	static private final String NAME_BLOOD_PRESSURE_MEAN = "MEAN ARTERIAL";
	static private final String SPLIT_CHARACTER = "/";
	static private final String VUID_WEIGHT = "4500639";

	public List parse(List dataResults, Reference parser, DataQuery dataQuery)
	{
		for(Object result : dataResults)
		{
			if(result instanceof VitalType)
			{
				VitalType vital = (VitalType) result;
				List<MeasurementType> measurements = vital.getMeasurements().getMeasurement();
				List<MeasurementType> addMeasurements = new ArrayList<MeasurementType>();

				for(MeasurementType measurement : measurements)
				{
					if(measurement.getVuid().equals(VUID_BLOOD_PRESSURE))
					{
						//String[] values = measurement.getValue().trim().split(SPLIT_CHARACTER);
						String[] values = StringUtils.split(measurement.getValue().trim(), SPLIT_CHARACTER);
						switch(values.length)
						{
						case 1:
							addMeasurements.add(makeSystolic(measurement, values[0], measurement.getValue()));
							break;

						case 2:
							addMeasurements.add(makeSystolic(measurement, values[0], measurement.getValue()));
							addMeasurements.add(makeDiastolic(measurement, values[1], measurement.getValue()));
							break;

						case 3:
							addMeasurements.add(makeSystolic(measurement, values[0], measurement.getValue()));
							addMeasurements.add(makeMeanArterial(measurement, values[1], measurement.getValue()));
							addMeasurements.add(makeDiastolic(measurement, values[2], measurement.getValue()));
							break;

						default:
							break;
						}

						measurement.setId(measurement.getId() + VUID_BLOOD_PRESSURE_ORIG);
						measurement.setVuid(VUID_BLOOD_PRESSURE + VUID_BLOOD_PRESSURE_ORIG);
					}
					if(measurement.getVuid().equals(VUID_WEIGHT))
					{
						String bmiValue = measurement.getBmi();
						if(StringUtils.isNotBlank(bmiValue))
						{
							if(StringUtils.contains(bmiValue, '*'))
							{
								bmiValue = StringUtils.replaceChars(bmiValue, "*", "");
								measurement.setBmi(bmiValue);
							}

							addMeasurements.add(makeBMI(measurement, bmiValue));

						}

					}
				}

				measurements.addAll(addMeasurements);
			}
		}

		return dataResults;
	}

	private MeasurementType makeBMI(MeasurementType measurement, String bmiValue)
	{
		MeasurementType ret = new MeasurementType();

		ret.setId(measurement.getId());
		ret.setVuid("BMI");
		ret.setName("BMI");
		ret.setValue(bmiValue);
		ret.setRawValue(measurement.getRawValue());
		ret.setUnits("kg/m2");
		ret.setUnit("kg/m2");
		ret.setBmi(bmiValue);
		ret.setVitalDisplay("BMI");
		ret.setVitalCode("39156-5");

		return ret;
	}

	private MeasurementType makeSystolic(MeasurementType measurement, String value, String raw)
	{
		return makeBPMeasurement(measurement, value, raw, VUID_BLOOD_PRESSURE_SYSTOLIC, NAME_BLOOD_PRESSURE_SYSTOLIC);
	}

	private MeasurementType makeDiastolic(MeasurementType measurement, String value, String raw)
	{
		return makeBPMeasurement(measurement, value, raw, VUID_BLOOD_PRESSURE_DIASTOLIC, NAME_BLOOD_PRESSURE_DIASTOLIC);
	}

	private MeasurementType makeMeanArterial(MeasurementType measurement, String value, String raw)
	{
		return makeBPMeasurement(measurement, value, raw, VUID_BLOOD_PRESSURE_MEAN, NAME_BLOOD_PRESSURE_MEAN);
	}

	private MeasurementType makeBPMeasurement(MeasurementType measurement, String value, String raw, String suffix, String prefix)
	{
		MeasurementType ret = new MeasurementType();

		ret.setId(measurement.getId() + suffix);
		ret.setVuid(measurement.getVuid() + suffix);
		ret.setName(prefix + " " + measurement.getName());
		ret.setValue(value);
		ret.setHigh(measurement.getHigh());
		ret.setLow(measurement.getLow());
		if(raw != null)
		{
			ret.setRawValue(raw);
		}
		else
		{
			ret.setRawValue(value);
		}
		
		if (ret.getRawValue().startsWith(SPLIT_CHARACTER))
		{
			ret.setRawValue('-' + ret.getRawValue());
		}
		if (ret.getRawValue().endsWith(SPLIT_CHARACTER))
		{
			ret.setRawValue(ret.getRawValue() + '-');
		}
		ret.setUnits(measurement.getUnits());
		ret.setMetricValue(measurement.getMetricValue());
		ret.setMetricUnits(measurement.getMetricUnits());

		return ret;
	}
}
