package gov.va.med.nhin.adapter.datamanager.internalApp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAppFilterObj
{
	private static final Logger logger = LoggerFactory.getLogger(InternalAppFilterObj.class.getName());

	private InternalAppOperations operation;
	private String filterValue;
	private String objectName;
	// If there is a sublist we are filtering, there needs to be a way of
	// specifying.
	// This will be a "." separated list if necessary.
	private String subRoot;

	/**
	 * @return the operation
	 */
	public InternalAppOperations getOperation()
	{
		return operation;
	}

	public void setoperation(final String operationStr)
	{
		try
		{
			operation = InternalAppOperations.valueOf(operationStr);
		}
		catch(NullPointerException | IllegalArgumentException ex)
		{
			logger.warn("Error setting operation: " + operationStr + ".  Validate DB has correct values", ex);
		}
	}

	/**
	 * @param operation the operation to set
	 */
	public void setOperation(InternalAppOperations operation)
	{
		this.operation = operation;
	}

	/**
	 * @return the filterValue
	 */
	public String getFilterValue()
	{
		return filterValue;
	}

	/**
	 * @param filterValue the filterValue to set
	 */
	public void setFilterValue(String filterValue)
	{
		this.filterValue = filterValue;
	}

	/**
	 * @return the objectName
	 */
	public String getObjectName()
	{
		return objectName;
	}

	/**
	 * @param objectName the objectName to set
	 */
	public void setObjectName(String objectName)
	{
		this.objectName = objectName;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append(this.getClass().getName()).append(": Sub Root: ").append(subRoot).append(" Comparing objectName ").append(objectName).append(" operation ");
		sb.append(operation.toString()).append(" and filter param ").append(filterValue);
		return sb.toString();
	}

	/**
	 * @return the subRoot
	 */
	public String getSubRoot()
	{
		return subRoot;
	}

	/**
	 * @param subRoot the subRoot to set
	 */
	public void setSubRoot(String subRoot)
	{
		this.subRoot = subRoot;
	}
}
