package gov.va.med.nhin.adapter.datamanager.filters;

import com.google.common.base.Objects;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author David Vazquez
 */
public class NoteFixingFilter implements DataFilter {

	private static final Logger logger = LoggerFactory.getLogger( NoteFixingFilter.class.getName() );

	@Override
	public boolean test( Object result, List results, Reference filterType, DataQuery dataQuery ) {
		final SmartHashMap smh = SmartHashMap.class.cast( result );
		final String logicMode = filterType.getProperty( "logicMode" );
		final String docClassField = filterType.getProperty( "docClassField" );
		final String idField = filterType.getProperty( "idField" );
		final String facilityField = filterType.getProperty( "facilityField" );

		final String docClass = String.class.cast( smh.get( docClassField ) );

		final boolean isPN = "PROGRESS NOTES".equalsIgnoreCase( docClass );


		// NOTE: this logic was provided in a spreadsheet during requirements gathering
		if ( "consult".equalsIgnoreCase( logicMode ) ) {
			if ( isPN ) {
				return isNewDoc( idField, facilityField, smh, results );
			}
		}
		else if ( "history".equalsIgnoreCase( logicMode ) ) {
			if ( isPN ) {
				final String titleServiceField = filterType.getProperty( "titleField" );
				final String titleService
						= String.class.cast( getMapValue( smh, titleServiceField ) );

				if ( "HISTORY & PHYSICAL".equalsIgnoreCase( titleService ) ) {
					return isNewDoc( idField, facilityField, smh, results );
				}
			}
		}
		else if ( "procedures".equalsIgnoreCase( logicMode ) ) {
			if ( isPN || "CLINICAL PROCEDURES".equalsIgnoreCase( docClass ) ) {
				final Set<String> services = new HashSet<>( Arrays.asList(
						"PROCEDURE",
						"DIAGNOSTIC STUDY",
						"DIAGNOSTIC INTERVENTIONAL PROCEDURE" ) );

				final String titleServiceField = filterType.getProperty( "titleField" );
				final String titleService
						= String.class.cast( getMapValue( smh, titleServiceField ) );
				if ( services.contains( String.class.cast( titleService ) ) ) {
					return isNewDoc( idField, facilityField, smh, results );
				}
			}
		}
		
		return false;
	}

	private static Object getMapValue( SmartHashMap map, String fieldname ) {
		if ( fieldname.contains( "." ) ) {
			int pos = fieldname.indexOf( "." );
			String root = fieldname.substring( 0, pos );

			if ( map.containsKey( root ) && map.get( root ) instanceof SmartHashMap ) {
				SmartHashMap map2 = SmartHashMap.class.cast( map.get( root ) );
				return getMapValue( map2, fieldname.substring( pos + 1 ) );
			}
		}

		return map.get( fieldname );
	}

	private static boolean isNewDoc( String idField, String facilityField,
			SmartHashMap smh, List<SmartHashMap> results ) {
		final Object facility = getMapValue( smh, facilityField );
		final Object id = getMapValue( smh, idField );

		for ( SmartHashMap haystack : results ) {
			Object hayid = getMapValue( haystack, idField );
			Object hayfac = getMapValue( haystack, facilityField );

			if ( Objects.equal( id, hayid ) && Objects.equal( facility, hayfac ) ) {
				return false;
			}
		}

		return true;
	}
}
