package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class NotInDataFilter implements DataFilter
{
	private static final Logger logger = LoggerFactory.getLogger(NotInDataFilter.class.getName());

	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		try
		{
			boolean ret = false;
			String valueName = filterType.getProperty("valueName");
			String inList = filterType.getProperty("inList");
			String value = BeanUtils.getProperty(result, valueName);

			logger.debug("value: {}", value);
			if(value == null)
			{
				// Prevent null pointer exception
				value = "";
			}

			for(String item : inList.split(","))
			{

				logger.debug("item: {}", item);

				if(value.equals(item))
				{
					ret = true;
					break;
				}
			}

			return !ret;
		}
		// CCR 1779231
		catch(Exception e)
		{
			throw new DataManagerException("An error occurred processing filter.", e);
		}
	}
}
