/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.filters;

import java.lang.reflect.*;
import java.util.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author DNS   
 */
public class MedsDataFilter implements DataFilter
{
    @Override
    public boolean test(Object result, List results, Reference filter, DataQuery dataQuery)
    {
        boolean ret = false;

        try {
            String vaType = (String) PropertyUtils.getProperty(result, "vaType");
            String vaStatus = (String) PropertyUtils.getProperty(result, "vaStatus");
            Date dispenseTime = (Date) PropertyUtils.getProperty(result, "dispenseTime");
            Date fifteenMonthsAgo = getFifteenMonthsAgo();
            String formatCode = (String) dataQuery.getParameter("formatCode");

            if (NullChecker.isNotNullOrEmpty(formatCode) && formatCode.equals("urn:hl7-org:sdwg:ccda-structuredBody:1.1")) {
                if (NullChecker.isNotNullOrEmpty(vaType)) {
                    if (vaType.equalsIgnoreCase("O")) {
                        ret = dispenseTime != null && dispenseTime.getTime() >= fifteenMonthsAgo.getTime()
                              && NullChecker.isNotNullOrEmpty(vaStatus) && !vaStatus.equalsIgnoreCase("DELETED");
                    }
                    else if (vaType.equalsIgnoreCase("N")) {
                        ret = NullChecker.isNotNullOrEmpty(vaStatus) && !vaStatus.equalsIgnoreCase("DISCONTINUED");
                    }
                }
            }
            else {
                ret = dispenseTime != null && dispenseTime.getTime() >= fifteenMonthsAgo.getTime()
                        && NullChecker.isNotNullOrEmpty(vaType)
                        && (vaType.equalsIgnoreCase("O") || vaType.equalsIgnoreCase("N"))
                        && NullChecker.isNotNullOrEmpty(vaStatus) && vaStatus.equalsIgnoreCase("ACTIVE");
            }
        }
        catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
            throw new DataManagerException("Error getting property from result.", e);
        }

        return ret;
    }

    private Date getFifteenMonthsAgo()
    {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH, -15);
        return cal.getTime();
    }
}
