/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager;

import org.apache.commons.beanutils.*;

/**
 *
 * @author David Vazquez
 * @param <T> type of bean
 */
public class BeanDataProxy<T> implements DataProxy<T>
{
    private T bean;

		@Override
    public void setObject(T bean)
    {
        this.bean = bean;
    }

		@Override
    public T getObject()
    {
        return bean;
    }

		@Override
    public Object get(String property)
    {
        Object ret = null;

        try {
            ret = PropertyUtils.getProperty(bean, property);
        }
        catch (Throwable t) {
            ret = null;
        }

        return ret;
    }

		@Override
    public void set(String property, Object value)
    {
        try {
            PropertyUtils.setProperty(bean, property, value);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to set property " + property + " on bean of type " + bean.getClass().getName());
        }
    }
}
