/* ----------------------------------------------------------------
 * File Name 	: SystemProperties.java
 * Authored By	: spawaradmin
 * Created on	: Feb 02, 2009
 * 
 * This is copyrighted software of the United States Federal Government.   
 * Any use must be authorized by the
 * 
 * 	     Department of Veterans Affairs
 * 	     National Health Information Network - (NHIN)
 * 	     
 *
 * Any un-authorized use is strictly prohibited and subject to 
 * legal action.
 * 
 * Purpose	:
 * 
 * 
 * --------------------------------------------------------------------
 *                 M o d i f i c a t i o n   H i s t o r y
 * 
 * Date 	:
 * Author 	:
 * Purpose 	: 
 * 
 * 
 * -------------------------------------------------------------------- 
 */

package gov.va.med.nhin.adapter.utils.datasharing.system;

public class SystemProperties {

    // Delivery Service Configuration Properties
    public class DeliveryServiceConfigurations
    {
	    // Configuration names specified in <configuration name = "" > tag
		public final static String DS_VATODOD_CONFIGURATION = "VAtoDoDConfiguration";
		public final static String DS_TOHDR_CONFIGURATION = "toHDRConfiguration";
		public final static String DS_DODTOVA_CONFIGURATION = "DoDtoVAConfiguration";
		public final static String DS_VISTATOCHDR_CONFIGURATION = "VistAtoCHDRConfiguration";
		public final static String DS_TEST_CONFIGURATION = "DSTestConfiguration";
		// DEVELOPERWORKSTATION platform name - developer workstation
		public final static String PLATFORM_DEVWORKSTATION = "DEVELOPMENTWORKSTATION";
	    // System platform property name
	    public final static String PLATFORM_PROPERTY_NAME = "CHDR.platform";
	    // DS Property Config file - if you dont want to use Properties.xml or it would default to that
	    public final static String DS_PROPERTY_SYSTEM_NAME = "DS.configFile";
    }
    
	// Message Formats
	public class MessageTypes
	{
		public final static String HL7XML = "HL7XML";
		public final static String HL7ER7 = "HL7ER7";
	}

	// Platform Configurations
	public class PlatformConfigurations
	{
		// DEVELOPERWORKSTATION platform name - developer workstation
		public final static String PLATFORM_DEVWORKSTATION = "DEVELOPMENTWORKSTATION";
		// DEVELOPERWORKSTATION platform name - developer workstation
		public final static String PLATFORM_DEVTEST = "DEVTEST";
		// DEVELOPERWORKSTATION platform name - developer workstation
		public final static String PLATFORM_SQA = "SQA";		
	    // System platform property name
	    public final static String PLATFORM_PROPERTY_NAME = "CHDR.platform";
	    // System Test Platform property name
	    public final static String PLATFORM_ISTEST_PROPERTY_NAME = "CHDR.testPlatform";
	    // Platform configuration file - if you dont want to use CHDR_Properties.xml
	    public final static String PLATFORM_SYSTEM_FILE_NAME = "Platform.config";
		// Is it a test environment - TRUE
		public final static String PLATFORM_ISTEST_TRUE = "true";
		// Is it a test environment - FALSE
		public final static String PLATFORM_ISTEST_FALSE = "false";
	}

	// Registry Services
	public class RegistryServices
	{
	    // MPI Adapter Service
	    public final static String REGISTRY_SERVICE_MPI = "MPIAdapter";
	    // CDS Adapter Service
	    public final static String REGISTRY_SERVICE_CDS = "CDSAdapter";
	}

	// NCPDP Configuration
	public class NCPDPConfigurations
	{
        // NCPDP Property Config file - if you dont want to use CHDR_Properties.xml or it would default to that
	    public static final String NCPDP_PROPERTY_FILE_NAME = "NCPDP.configFile";
	}

    public class Correlator
    {
        public static final String CORRELATOR_TYPE = "Correlator.Type";

    }
    
//    public static long getTimeToLive() {
//        return PropertyMgr.getInstance()
//            .getProperty("Default/ThreadTimeToLive").getLong();
//    }
//    public static boolean isOptimizeAuditable() {
//        return PropertyMgr.getInstance()
//            .getProperty("AuditService/OptimizeStorage").getBoolean();
//    }
//    public static boolean isFilterAuditDisplay() {
//        return PropertyMgr.getInstance()
//        .getProperty("AuditService/FilterDisplay").getBoolean();
//    }
//    public static String getAuditPageCount() {
//        return PropertyMgr.getInstance()
//        .getProperty("AuditService/PageCount").getString();
//    }
//    public static int getTimeout() {
//        return PropertyMgr.getInstance()
//            .getProperty("CorrelatorService/TimeOut").getInt();
//    }
//    public static int getStorageCharSize() {
//        return PropertyMgr.getInstance()
//        .getProperty("Default/CharStorageSize").getInt();
//    }
//    public static long getCachePoolInterval() {
//        return PropertyMgr.getInstance()
//            .getProperty("Default/CachePoolInterval").getLong();
//    }
//    public static long getRetryInterval() {
//        return PropertyMgr.getInstance()
//            .getProperty("Default/RetryInterval").getLong();
//    }
//    public static long getExpiryInterval() {
//        return PropertyMgr.getInstance()
//            .getProperty("Default/ExpiryInterval").getLong();
//    }

}

