/* ----------------------------------------------------------------
 * File Name 	: HL7DCLLPTransceiver.java
 * Authored By	: spawaradmin
 * Created on	: Feb 02, 2009
 * 
 * This is copyrighted software of the United States Federal Government.   
 * Any use must be authorized by the
 * 
 * 	     Department of Veterans Affairs
 * 	     National Health Information Network - (NHIN)
 * 	     
 *
 * Any un-authorized use is strictly prohibited and subject to 
 * legal action.
 * 
 * Purpose	:
 * 
 * 
 * --------------------------------------------------------------------
 *                 M o d i f i c a t i o n   H i s t o r y
 * 
 * Date 	:
 * Author 	:
 * Purpose 	: 
 * 
 * 
 * -------------------------------------------------------------------- 
 */

package gov.va.med.nhin.adapter.utils.datasharing.messaging.transceiver;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class HL7DCLLPTransceiver extends SocketTransceiver
{
	private static final String STR_CRLF = "\r\n";
	private static final String STR_CR = "\r";
	private static final char CR = '\r';
	private static final int PREFIX_LENGTH = 3;
	private static final String DATA_TERMINATOR = "\u001B\u001B\u001B";
	private static final String DATA_BEGIN_MARKER = "DATA PARAM=MPI\r\n";
	private int msgCount;

	public HL7DCLLPTransceiver()
	{
		init(new Properties());
	}

	public HL7DCLLPTransceiver(Properties p)
	{
		init(p);
	}

	private void init(Properties p)
	{
		if(p != null && p instanceof Properties)
			serviceProperties = p;
		else
			serviceProperties = new Properties();
	}

	public String formatIncomingMessage(String msg) throws MessageLLPException
	{
		int count = 0;
		int marker = 0;
		StringBuffer result = new StringBuffer();
		if((marker = msg.indexOf(DATA_BEGIN_MARKER)) == -1)
		{
			// logger.debug("Bad msg: " + msg);
			throw new MessageMarkerException("MPI Data Begin marker is not found");
		}
		else
			marker += DATA_BEGIN_MARKER.length();
		while(marker < msg.length())
		{
			count = Integer.parseInt(msg.substring(marker, marker + PREFIX_LENGTH));
			if(count > 0)
			{
				String ss = msg.substring(marker + PREFIX_LENGTH, marker + PREFIX_LENGTH + count);
				if(!ss.equals(DATA_TERMINATOR))
				{
					result.append(ss);
				}
			}
			else
			{
				if(result.charAt(result.length() - 1) != CR)
				{
					result.append(CR);
				}
			}
			marker = marker + PREFIX_LENGTH + count;
		}
		return result.toString();
	}

	private String formatOutgoingMessage(String msg) throws MessageLLPException
	{
		String[] results = new String[4];
		String[] parts = msg.split(STR_CR);
		if(parts.length != 3)
			throw new MessageLLPException("Query has to have exactly 3 segments.");

		for(int i = 0; i < parts.length; i++)
			results[i] = parts[i];
		results[3] = DATA_TERMINATOR;
		StringBuffer message = new StringBuffer();
		for(int i = 0; i < results.length; i++)
		{
			String prefix = String.valueOf(results[i].length());
			while(prefix.length() < PREFIX_LENGTH)
			{
				prefix = "0" + prefix;
			}
			message.append(prefix).append(results[i]);
		}
		return message.toString();
	}

	protected void sendCommand(String command, OutputStream outStream) throws MessageLLPException
	{
		send(command, outStream);
	}

	protected void sendData(String data, OutputStream outStream) throws MessageLLPException
	{
		String message = formatOutgoingMessage(data);
		send(message, outStream);
	}

	protected String receiveCommandResponse(InputStream inStream) throws MessageLLPException
	{
		return receive(inStream, STR_CRLF, 0);
	}

	protected String receiveData(InputStream inStream) throws MessageLLPException
	{
		String message = this.receive(inStream, DATA_TERMINATOR, 0);
		return(formatIncomingMessage(message));
	}

	protected String sendMessage(String msg, InputStream ins, OutputStream outs) throws MessageLLPException
	{
		String ss = null;
		String data = null;
		sendCommand("HELO" + STR_CRLF, outs);

		ss = receiveCommandResponse(ins);

		if(ss.startsWith("2"))
		{
			sendCommand("DATA PARAM=MPI" + STR_CRLF, outs);
			sendData(msg, outs);
			ss = receiveCommandResponse(ins);
			sendCommand("TURN" + STR_CRLF, outs);
			// ss = receiveCommandResponse(ins);
			data = receiveData(ins);
			sendCommand("200 OK" + STR_CRLF, outs);
			sendCommand("QUIT" + STR_CRLF, outs);
		}
		else
		{
			sendCommand("QUIT" + STR_CRLF, outs);
			throw new MessageLLPException("Error code " + ss + " received from MPI.");
		}
		return data;
	}

	public Object transceive(Object payload) throws MessageLLPException, IOException {
		msgCount++;
		String result = "";
		int tries = 4;
		int tried = 0;
		InputStream is = null;
		OutputStream os = null;

		while(true)
		{
			connect();
			try
			{
				tried++;
				is = getInputStream();
				os = getOutputStream();
				result = sendMessage((String) payload, is, os);
				return result;
			}
			catch(MessageMarkerException e)
			{
				if(tried >= tries)
				{
					// e.printStackTrace();
					throw new MessageLLPException("MPI Data Begin Marker is not found, tried " + tried + " times ... ", e);
				}
			}
			finally
			{
				if(is != null)
				{
					safeClose(is);
				}
				if(os != null)
				{
					safeClose(os);
				}
				disconnect();
			}
		}
	}

	public static void safeClose(InputStream fis) {
		if (fis != null) {
			try {
				fis.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public static void safeClose(OutputStream fos) {
		if (fos != null) {
			try {
				fos.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public static void main(String[] args) throws Exception
	{
		String mpiQuery = "MSH|^~\\&|MPI_LOAD|200M|MPI-ICN||20050202105053-0500||VQQ^Q02|" + System.currentTimeMillis() + "|T|2.4|||AL|NE|\r" + "VTQ|" + System.currentTimeMillis() + "|T|VTQ_PID_ICN_NO_LOAD|ICN|@00108.1^EQ^CHDRKCCAAD^AND~@00108.2^EQ^MANADC^AND~@00111^EQ^M^AND~@00122^EQ^666010004^AND~@00110^EQ^19550114\r" + "RDF|8|@00108.2^ST^30~@00108.3^ST^16~@00108.1^ST^30~@00122^ST^9~@00110^ST^8~@00105^ST^19~@00756^ST^5~@00169^ST^999\r";
		String strTestOutput = "";

		Properties serviceProperties = new Properties();
		/* IP          test IP             prod */
		serviceProperties.setProperty(SocketTransceiver.PROP_HOST, "IP         ");
		/* 15500 test 5500 prod */
		serviceProperties.setProperty(SocketTransceiver.PROP_PORT, Integer.toString(15500));
		serviceProperties.setProperty(SocketTransceiver.PROP_TOUT, Long.toString(300000L));
		serviceProperties.setProperty(SocketTransceiver.PROP_SFAC, "200HD.DNS        URL        ");
		/* prod=MPI-URL        , test=.DNS        URL         */
		serviceProperties.setProperty(SocketTransceiver.PROP_RFAC, ".DNS        URL        ");
		serviceProperties.setProperty(SocketTransceiver.PROP_LATT, "NT");
		HL7DCLLPTransceiver tr = new HL7DCLLPTransceiver(serviceProperties);
		long st;
		String queryResults;
		System.out.println(mpiQuery);
		st = System.currentTimeMillis();
//		queryResults = (String) tr.transceive(mpiQuery);
//		tr.getOutputStream();
//		strTestOutput = tr.getOutputStream().toString();
//
//		System.out.println("\n" + queryResults);
//		System.out.println("Output String: " + strTestOutput);
	}
}