package gov.va.med.nhin.adapter.datamanager.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.utils.datasharing.messaging.transceiver.HL7DCLLPTransceiver;
import gov.va.med.nhin.adapter.utils.datasharing.messaging.transceiver.MessageLLPException;
import gov.va.med.nhin.adapter.utils.datasharing.messaging.transceiver.SocketTransceiver;
import gov.va.med.nhin.adapter.utils.datasharing.services.person.vo.PersonIdentityVO;
import gov.va.med.nhin.adapter.utils.datasharing.system.DateTimeUtility;

/**
 *
 * @author SPAWAR New Orleans
 */
public class MPIDataAdapter implements DataAdapter
{
	public static final Logger logger = LoggerFactory.getLogger(MPIDataAdapter.class.getName());

	/**
	 * getData
	 *
	 * @param dataResults
	 * @throws gov.va.med.nhin.adapter.datamanager.DataManagerException
	 *
	 *             gathers the necessary connection information from the
	 *             dataManagerConfig.xml builds a PersonIdentityVO object with
	 *             demographics for the dataQuery either find or match will be
	 *             called based on the findType property
	 *
	 *
	 */
	public List getData(DataQuery dataQuery)
	{
		// CCR 177986
		logger.debug(getClass().getName() + "{}", "getData");

		try
		{
			Properties serviceProperties = new Properties();

			serviceProperties.setProperty(SocketTransceiver.PROP_HOST, dataQuery.getProperty("PROP_HOST"));
			serviceProperties.setProperty(SocketTransceiver.PROP_PORT, dataQuery.getProperty("PROP_PORT"));
			serviceProperties.setProperty(SocketTransceiver.PROP_TOUT, dataQuery.getProperty("PROP_TOUT"));
			serviceProperties.setProperty(SocketTransceiver.PROP_SFAC, dataQuery.getProperty("PROP_SFAC"));
			serviceProperties.setProperty(SocketTransceiver.PROP_RFAC, dataQuery.getProperty("PROP_RFAC"));
			serviceProperties.setProperty(SocketTransceiver.PROP_LATT, dataQuery.getProperty("PROP_LATT"));

			PersonIdentityVO pi1 = new PersonIdentityVO();

			MPIRequests mpi = new MPIRequests(serviceProperties);

			String df = (String) dataQuery.getParameter("firstName");
			if(df != null)
			{
				pi1.setFirstName(df);
			}
			df = (String) dataQuery.getParameter("middleInitial");
			if(df != null)
			{
				pi1.setMiddleInitial(df);
			}
			df = (String) dataQuery.getParameter("lastName");
			if(df != null)
			{
				pi1.setLastName(df);
			}
			df = (String) dataQuery.getParameter("sex");
			if(df != null)
			{
				pi1.setSex(df);
			}
			df = (String) dataQuery.getParameter("ssn");
			if(df != null)
			{
				pi1.setSSN(df);
			}
			df = (String) dataQuery.getParameter("dob");
			if(df != null)
			{
				pi1.setDOB(df);
			}
			df = (String) dataQuery.getParameter("prefix");
			if(df != null)
			{
				pi1.setPrefixName(df);
			}
			df = (String) dataQuery.getParameter("suffix");
			if(df != null)
			{
				pi1.setSuffixName(df);
			}
			String findType = "EXACT_MATCH_QUERY";
			df = (String) dataQuery.getParameter("findType");
			if(df != null)
			{
				findType = df;
			}
			if(findType.equalsIgnoreCase("EXACT_MATCH_QUERY"))
			{
				return mpi.findMatch(pi1, findType);
			}
			else
			{
				return mpi.findCandidates(pi1, findType);
			}
		}
		// CCR 179231
		catch(MessageLLPException e)
		{
			throw new DataManagerException("An error occurred when getting data.", e);
		}
		catch(Exception e)
		{
			throw new DataManagerException("An error occurred when getting data.", e);
		}
	}

	public class MPIRequests
	{

		private HL7DCLLPTransceiver llpTrans;
		boolean aFlag;
		StringBuffer requestBuffer;

		/**
		 * MPIrequests
		 *
		 * @param properties
		 * @param drs
		 */
		public MPIRequests(Properties properties)
		{
			llpTrans = new HL7DCLLPTransceiver(properties);
			// host: IP          test1 - IP          test2 - IP             prod
			// port: 15500 test 5500 prod
			// IP          test1 - IP             prod - IP         test2
			// Bay Pines TLMPI IP          
			//
			// serviceProperties.setProperty(SocketTransceiver.PROP_HOST,
			// "IP         ");
			// /* 15500 test 5500 prod */
			// /* 5005 for find ???? */
			// /* 5500 for add ???? */
			// /* 15000 or 15500 Bay Pines*/
			//
			// serviceProperties.setProperty(SocketTransceiver.PROP_PORT,
			// Integer.toString(15500));
			// serviceProperties.setProperty(SocketTransceiver.PROP_TOUT,
			// Long.toString(300000L));
			// serviceProperties.setProperty(SocketTransceiver.PROP_SFAC,
			// "200HD.DNS        URL        ");
			// prod=URL        ,
			// test=.DNS        URL        
			// serviceProperties.setProperty(SocketTransceiver.PROP_RFAC,
			// ".DNS        URL        ");
			// serviceProperties.setProperty(SocketTransceiver.PROP_RFAC,
			// ".DNS        URL        ");
			// serviceProperties.setProperty(SocketTransceiver.PROP_LATT, "NT");

		}

		/**
		 * findCandidates
		 *
		 * @param pi
		 * @param type
		 * @throws gov.va.med.datasharing.messaging.transceiver.
		 *             MessageLLPException
		 * @throws gov.va.med.nhin.adapter.datamanager.DataManagerException
		 *
		 *             can find multiple matches to parameters like (lastname +
		 *             firstname + dob )
		 */
		public List findCandidates(PersonIdentityVO pi, String type) throws MessageLLPException, DataManagerException
		{
			try
			{
				String req = createFindRequest(pi, type); // "VTQ_PID_ICN_NO_LOAD"
				return llpFind(req);
			}
			// CCR 179231- Update for Exception handling
			catch(Exception e)
			{
				throw new DataManagerException("An error occurred in MPIRequests.findCandidates.", e);
			}
		}

		/**
		 * findMatch
		 *
		 * @param pi
		 * @param type
		 * @throws gov.va.med.datasharing.messaging.transceiver.
		 *             MessageLLPException
		 * @throws gov.va.med.nhin.adapter.datamanager.DataManagerException
		 *
		 *             this is an exact match
		 *
		 */
		public List findMatch(PersonIdentityVO pi, String type) throws MessageLLPException, DataManagerException
		{
			try
			{
				String req = createFindRequest(pi, type); // "EXACT_MATCH_QUERY"
				return llpFind(req);
			}
			// CCR 179231- Update for Exception handling
			catch(Exception e)
			{
				throw new DataManagerException("An error occurred in MPIRequests.findMatch.", e);
			}
		}

		/**
		 * llpFind
		 *
		 * @param dataQuery
		 * @throws gov.va.med.datasharing.messaging.transceiver.
		 *             MessageLLPException
		 * @throws gov.va.med.nhin.adapter.datamanager.DataManagerException
		 *
		 *             parse the HL7 return message for results
		 *
		 */
		public List llpFind(String query) throws MessageLLPException, DataManagerException, IOException {
			// System.out.println("\n Query: \n" + dataQuery + "\n");
			ArrayList<Map> ret = new ArrayList<Map>();

			String mpiQuery = (String) llpTrans.transceive(query);
			// System.out.println("mpiquery:\n" + mpiQuery);
			// parse response
			// MSH|^~&|MPI|MPI|MPI_LOAD|200M|20050413141146.327-0400||ACK^Q02|1113415906327|P|2.3
			// MSA|AA|1113415906327
			// QAK|1113415906327|OK
			// RDF|14|@00108.1^ST^20~@00108.2^ST^20~@00108.3^ST^16~@00122^ST^9~@00110^ST^8~@00111^ST^1~@00756^ST^3~@00105^ST^19~@00740^ST^8~@00126.1^ST^30~@00126.2^ST^3~@00108.5^ST^15~@00108.4^ST^10~@00109.1^ST^20
			// RDT|XXXXX|XXXXXX|W|027365224|19471012|M|516|9999999999V275041||HYANNIS|MA|||
			// RDT|XXXXX|XXXXXX1|N|027367096|19471021|M|523|9999999999V836733|19970921|BROCKTON|MA|||

			String lines[] = mpiQuery.split("\r");
			try
			{
				for(int i = 4; i < lines.length; i++)
				{
					HashMap<String, String> dataResult = new HashMap<String, String>();

					// System.out.println(lines[i]);
					String records[] = lines[i].split("\\|");
					for(int r = 1; r < records.length; r++)
					{
						dataResult.put(Integer.toString(r), records[r]);
						/*
						 * switch (r) { case 1: dataResult.setData("lastName",
						 * records[r]); //1 break; case 2:
						 * dataResult.setData("firstName", records[r]); //2
						 * break; case 3: dataResult.setData("middleName",
						 * records[r]); // middle break; case 4:
						 * dataResult.setData("ssn", records[r]); //4 break;
						 * case 5: dataResult.setData("DOB", records[r]); //5
						 * break; case 6: dataResult.setData("sex", records[r]);
						 * //6 break; case 7: dataResult.setData("ICN",
						 * records[r]); //7 break; case 12:
						 * dataResult.setData("prefix",records[r]); // 12 prefix
						 * break; case 13: dataResult.setData("suffix",
						 * records[r]); // 13 suffix break; default: break; }
						 */
					}
					ret.add(dataResult);
				}
			}
			// CCR 179231- Update for Exception handling
			catch(Exception e)
			{
				throw new DataManagerException("An error occurred in MPIRequests.llpfind.", e);
			}

			return ret;
		}

		// private PersonIdentityVO getResultItem(int index) {
		// if (results == null || index < 0 || index >= results.size()) {
		// return null;
		// }
		// String[] ra = ((String) ((Vector) results).get(index)).split("\\|");
		// PersonIdentityVO rp = new PersonIdentityVO();
		// int ral = ra.length;
		// rp.setLastName(ra[1]);
		// rp.setFirstName(ra[2]);
		// rp.setMiddleInitial(ra[3]);
		// rp.setSSN(ra[4]);
		// rp.setDOB(ra[5]);
		// rp.setSex(ra[6]);
		// rp.setVAID(ra[7]);
		// if (ral > 15) {
		// rp.setPCF(ra[8]);
		// rp.setAddress1(ra[9]);
		// rp.setAddress2(ra[9]); //city
		// rp.setAddress3(ra[10]); //state
		// rp.setPrefixName(ra[12]);
		// rp.setSuffixName(ra[13]);
		// rp.setSites(ra[15]);
		// }
		// return rp;
		// }
		//
		// Vector getResultItems() {
		// Vector rv = new Vector();
		// for (int i = 0; i < results.size(); i++) {
		// rv.add(getResultItem(i));
		// }
		// return rv;
		// }

		/**
		 * createFindRequest
		 *
		 * @param pi
		 * @param dataQuery
		 * @return
		 *
		 * 		build the HL7 message using the VQQ^Q02 find candidate
		 * 
		 */
		String createFindRequest(PersonIdentityVO pi, String query)
		{

			aFlag = false;
			requestBuffer = new StringBuffer(100);
			requestBuffer.append("MSH|^~&|MPI_LOAD|200M|MPI-ICN|");
			requestBuffer.append("|" + DateTimeUtility.getCurrentTime());
			requestBuffer.append("||VQQ^Q02|");
			requestBuffer.append(System.currentTimeMillis() + "");
			requestBuffer.append("|T|2.4|||AL|NE|");
			requestBuffer.append("\r");

			requestBuffer.append("VTQ|");
			requestBuffer.append(System.currentTimeMillis() + "");
			requestBuffer.append("|T|" + query + "|ICN|");
			addSearchProp("@00108.1^EQ^", pi.getLastName()); // EQ equals CT
																// contains
			addSearchProp("@00108.2^EQ^", pi.getFirstName());
			addSearchProp("@00108.3^EQ^", pi.getMiddleInitial());
			addSearchProp("@00110^EQ^", pi.getDOB_VA_Format());
			addSearchProp("@00111^EQ^", pi.getSex());
			addSearchProp("@00122^EQ^", pi.getSSN());
			addSearchProp("@00108.4^EQ^", pi.getSuffixName());
			addSearchProp("@00108.5^EQ^", pi.getPrefixName());
			requestBuffer.append("\r");

			requestBuffer.append("RDF|15|@00108.1^ST^20~@00108.2^ST^20~@00108.3^ST^16~@00122^ST^9~@00110^ST^8~@00111^ST^1~@00105^ST^19~@00756^ST^3~@00740^ST^8~@00126.1^ST^30~@00126.2^ST^3~@00108.5^ST^15~@00108.4^ST^10~@00109.1^ST^20~@00169^ST^1000~@00109.1^ST^20~@POW~@00114.1^ST^20~@00114.2^ST^20~@00114.3^ST^20~@00114.4^ST^20~@00114.5^ST^20~@00114.6^ST^20~@00114.7^ST^20");
			// 1-last 2-first 3-middle 4-ssn 5-dob 6-sex 7-ICN 8-PCS 9-DOD
			// 10-BPC
			// 11-BPS 12-prefix 13-suffix 14-maiden 15-Treating facilites
			// 16-Maiden Name 17-Pow 18- street address1 19- street address2 20-
			// street address3
			// 21-City 22-State 23-Zip 24-Phone number
			requestBuffer.append("\r");

			return requestBuffer.toString();

			// * = input, + = output
			// *+ 7 ;;@00105;ICN;0;1;.01
			// *+ 4 ;;@00122;SSN;0;14;13
			// *+ 1 ;;@00108.1;LAST NAME;0;2;1
			// *+ 2 ;;@00108.2;FIRST NAME;0;3;2
			// *+ 3 ;;@00108.3;MIDDLE;0;4;3
			// + 13 ;;@00108.4;NAME SUFFIX;0;6;5
			// + 12 ;;@00108.5;NAME PREFIX;0;5;4
			// + 10 ;;@00126.1;BIRTH PLACE CITY;0;9;8
			// + 11 ;;@00126.2;BIRTH PLACE STATE;0;10;9;P;
			// + 14 ;;@00109.1;MOTHER'S MAIDEN NAME;0;7;6
			// *+ 6 ;;@00111;SEX;0;13;12
			// + 8 ;;@00756;PRIMARY CARE SITE;1;2;16;P;^DIC(4,
			// + 9 ;;@00740;DATE OF DEATH;0;11;10;D
			// *+ 5 ;;@00110;DOB;0;8;7;D
			// + 16 ;;@00109;MA'S MAIDEN NAME;0;7;6
			// + 15 ;;@00169;TREATING FACILITY (MULTIPLE--FILE 985.5);;;;
			// ;;@ZEL6;CLAIM NUMBER;1;1;15
			// ;;@00112.1;ALIAS LAST NAME;985.02;1;.01
			// ;;@00112.2;ALIAS FIRST NAME;985.02;2;1
			// ;;@00112.3;ALIAS MIDDLE NAME;985.02;3;2
			// ;;@00112.4;ALIAS SUFFIX;985.02;5;4
			// ;;@00112.5;ALIAS PREFIX;985.02;4;3
			// 17 ;;@POW;POW STATUS;2;9;38
			// ;;@00127;MULITPLE BIRTH;2;10;39
		}

		void addSearchProp(String t, String p)
		{
			if(p != null && p.length() > 0)
			{
				if(aFlag)
				{
					requestBuffer.append("^AND~");
				}
				requestBuffer.append(t);
				requestBuffer.append(p);
				aFlag = true;
			}
		}
	}
}
