package gov.va.med.nhin.adapter.datamanager.adapters;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.GenericSegment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v24.datatype.QSC;
import ca.uhn.hl7v2.model.v24.message.VQQ_Q07;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.VTQ;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class HL7VQQDataAdapter extends HL7DCLLPDataAdapter
{
	static private String[] FIELDS = { "@00108.1", "@00122", "@00110", "@00108.2", "@00740", "@00108.3", "@00111", "@00126.1", "@00126.2", "@00108.4" };

	String buildMessage(DataQuery dataQuery) throws Exception
	{
		String template = dataQuery.getProperty("template").trim();

		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmss");
		Date currentTime = new Date();

		Parser parser = new GenericParser();
		VQQ_Q07 message = (VQQ_Q07) parser.parse(template);

		MSH msh = message.getMSH();
		msh.getDateTimeOfMessage().getTimeOfAnEvent().setValue(formatter.format(currentTime));
		msh.getMessageType().getMessageType().setValue("VQQ");
		msh.getMessageType().getTriggerEvent().setValue("Q02");
		msh.getMessageControlID().setValue(Long.toString(currentTime.getTime()));
		msh.getProcessingID().getProcessingID().setValue(dataQuery.getProperty("processingId"));

		VTQ vtq = message.getVTQ();
		// vtq.getQueryTag().setValue(Long.toString(currentTime.getTime()));

		int criteriaAdded = 0;
		for(int i = 0; i < FIELDS.length; ++i)
		{
			String value = (String) dataQuery.getParameterBySource(FIELDS[i]);
			if(!NullChecker.isNullOrEmpty(value))
			{
				QSC qsc = vtq.getSelectionCriteria(criteriaAdded);
				qsc.getSegmentFieldName().setValue(FIELDS[i]);
				qsc.getValue().setValue(value);
				qsc.getRelationalOperator().setValue("EQ");
				if(criteriaAdded > 0)
				{
					vtq.getSelectionCriteria(criteriaAdded - 1).getRelationalConjunction().setValue("AND");
				}
				++criteriaAdded;
			}
		}

		return parser.encode(message);
	}

	List processResponse(DataQuery dataQuery, String response) throws Exception
	{
		String r = response.replaceAll("Q02", "Q07");
		List ret = new ArrayList<Map>();
		Parser parser = new GenericParser();
		GenericMessage message = (GenericMessage) parser.parse(r);

		String[] fieldNames = getFieldNames(message);

		String lines[] = response.split("\r");
		for(int i = 4; i < lines.length; ++i)
		{
			String line = lines[i];
			HashMap<String, String> dataResult = new HashMap<String, String>();
			String[] fields = line.split("\\|");
			for(int j = 1; j < fields.length; ++j)
			{
				dataResult.put(fieldNames[j - 1], fields[j]);
			}
			ret.add(dataResult);
		}

		return ret;
	}

	private String[] getFieldNames(GenericMessage message) throws Exception
	{
		String[] ret;
		Structure[] rdfs = (Structure[]) message.getAll("RDF");
		GenericSegment seg = (GenericSegment) rdfs[0];
		Varies countField = (Varies) seg.getField(1, 0);
		int count = Integer.parseInt(((GenericPrimitive) countField.getData()).getValue());
		ret = new String[count];

		for(int i = 0; i < count; ++i)
		{
			Varies dataField = (Varies) seg.getField(2, i);
			GenericComposite data = (GenericComposite) dataField.getData();
			ret[i] = ((GenericPrimitive) ((Varies) data.getComponent(0)).getData()).getValue();
		}

		return ret;
	}
}
