package gov.va.med.nhin.adapter.patientdiscovery;

import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationRequestType;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationResponseType;
import gov.va.nvap.privacy.ConsentDirectiveQueryRequestType;
import gov.va.nvap.privacy.ConsentDirectiveQueryResponseType;
import gov.va.nvap.privacy.ConsentDirectiveRevocationRequestType;
import gov.va.nvap.privacy.ConsentDirectiveRevocationResponseType;
import gov.va.nvap.privacy.OrganizationTrustedSourceRequestType;
import gov.va.nvap.privacy.OrganizationTrustedSourceResponseType;
import privacy.service.nvap.va.gov.ConsentManagementPortType;
import privacy.service.nvap.va.gov.ConsentManagementService;
import privacy.service.nvap.va.gov.ConsentManagementServiceFaultMessage;

/**
 *
 * @author Zack Peterson
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "CMProxyVAP")
public class CMProxyVAP implements CMProxy
{
	private static final Logger logger = LoggerFactory.getLogger(CMProxyVAP.class);

	private ConsentManagementService consentManagementService;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	private ConsentManagementPortType getConsentManagementPort()
	{
		if(consentManagementService == null)
		{
			try
			{
				consentManagementService = new ConsentManagementService(new URL(propertyLookup.getProperty("ConsentManagementServiceWSDL")), new QName("http://gov.va.nvap.service.privacy/", "ConsentManagementService"));
			}
			catch(Throwable t)
			{
				throw new RuntimeException("Unable to get ConsentManagementPort.");
			}
		}

		ConsentManagementPortType port = consentManagementService.getConsentManagementPort();
		return port;
	}

	public ConsentDirectiveAuthorizationResponseType processConsentDirectiveAuthorization(ConsentDirectiveAuthorizationRequestType request)
	{
		try
		{
			return getConsentManagementPort().processConsentDirectiveAuthorization(request);
		}
		catch(ConsentManagementServiceFaultMessage ex)
		{
			// TODO: Improve exception handling
			logger.error("error duing processConsentDirectiveAuthorization()", ex);
		}

		return null;
	}

	public ConsentDirectiveRevocationResponseType processConsentDirectiveRevocation(ConsentDirectiveRevocationRequestType request)
	{
		try
		{
			return getConsentManagementPort().processConsentDirectiveRevocation(request);
		}
		catch(ConsentManagementServiceFaultMessage ex)
		{
			// TODO: Improve exception handling
			logger.error("error duing processConsentDirectiveRevocation()", ex);
		}

		return null;
	}

	public ConsentDirectiveQueryResponseType getConsentDirectives(ConsentDirectiveQueryRequestType request)
	{
		try
		{
			return getConsentManagementPort().getConsentDirectives(request);
		}
		catch(ConsentManagementServiceFaultMessage ex)
		{
			// TODO: Improve exception handling
			logger.error("error duing getConsentDirectives()", ex);

		}

		return null;
	}

    public OrganizationTrustedSourceResponseType getIsOrganizationTrustedSource(OrganizationTrustedSourceRequestType request) {
        try
        {
            return getConsentManagementPort().getIsOrganizationTrustedSource(request);
        }
        catch(ConsentManagementServiceFaultMessage ex)
        {
            // TODO: Improve exception handling
            logger.error("error duing getIsOrganizationTrustedSource()", ex);

        }

        return null;
    }
}