package gov.va.med.nhin.adapter.errors;

import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.ejb.EJB;
import javax.ejb.*;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryErrorList;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;

@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "CreateResponseError")
public class CreateResponseError implements CreateErrorInterface
{
	private static Logger logger = LoggerFactory.getLogger(CreateResponseError.class.getName());

	static private final String ERROR_XDS_REPOSITORY_ERROR = "XDSRepositoryError";
	static private final String ERROR_DESC_XDS_REPOSITORY_ERROR = "Internal Registry/Repository Error";

	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	/**
	 * Generate a Doc Query error message.
	 */
	public AdhocQueryResponse createAdhocQueryResponseError(final Object request, final ErrorMessage error)
	{
		oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
		AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
		AdhocQueryRequest fromAdhocQueryRequest = null;
		if(request != null)
		{
			Method methods[] = request.getClass().getMethods();
			for(Method method : methods)
			{
				if("getAdhocQueryRequest".equalsIgnoreCase(method.getName()))
				{
					// Should be AdHocQueryRequest
					Object reqObj = null;

					try
					{
						reqObj = method.invoke(request, null);
					}
					catch(IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
					{
						logger.error("Illegal Exception - Failed to parse incoming object methods");
					}

					if(reqObj instanceof AdhocQueryRequest)
					{
						fromAdhocQueryRequest = (AdhocQueryRequest) reqObj;
					}
				}
			}
		}

		ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
		ret.setRegistryErrorList(createRegistryErrorList(error, StringUtils.EMPTY));
		if(fromAdhocQueryRequest != null && StringUtils.isNotEmpty(fromAdhocQueryRequest.getId()))
		{
			ret.setRequestId(fromAdhocQueryRequest.getId());
		}
		ret.setRegistryObjectList(new RegistryObjectListType());

		return ret;
	}

	public RetrieveDocumentSetResponseType createRetrieveDocumentError(final String errorCode, final String codeContext)
	{
		return createRetrieveDocumentError(errorCode, codeContext, StringUtils.EMPTY);
	}

	public RetrieveDocumentSetResponseType createRetrieveDocumentError(final String errorCode, final String codeContext, final String hcid)
	{
		ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
		RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
		
		if(StringUtils.isNotBlank(hcid))
		{
			ret.setRegistryResponse(createRegistryResponseError(errorCode, codeContext, hcid));
		}
		else
		{
			ret.setRegistryResponse(createRegistryResponseError(errorCode, codeContext, StringUtils.EMPTY));
		}
		
		return ret;
	}

	public RetrieveDocumentSetResponseType createRetrieveDocumentError(final ErrorMessage error)
	{
		return createRetrieveDocumentError(error, StringUtils.EMPTY);
	}

	public RetrieveDocumentSetResponseType createRetrieveDocumentError(final ErrorMessage error, final String hcid)
	{
		ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
		RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
		if(StringUtils.isNotBlank(hcid))
		{
			ret.setRegistryResponse(createRegistryResponseError(error, hcid));
		}
		else
		{
			ret.setRegistryResponse(createRegistryResponseError(error, StringUtils.EMPTY));
		}
		return ret;
	}

	private RegistryResponseType createRegistryResponseError(String errorCode, String codeContext, final String hcid)
	{
		RegistryResponseType ret = new RegistryResponseType();
		ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
		ret.setRegistryErrorList(createRegistryErrorList(errorCode, codeContext, hcid));
		return ret;
	}

	private RegistryResponseType createRegistryResponseError(final ErrorMessage error, final String hcid)
	{
		RegistryResponseType ret = new RegistryResponseType();
		ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
		ret.setRegistryErrorList(createRegistryErrorList(error, hcid));
		return ret;
	}

	private RegistryErrorList createRegistryErrorList(final ErrorMessage error, final String hcid)
	{
		if(error != null)
		{
			return createRegistryErrorList(ERROR_XDS_REPOSITORY_ERROR, ERROR_DESC_XDS_REPOSITORY_ERROR + ": " + error.getMessage(), hcid);
		}

		return createRegistryErrorList(ERROR_XDS_REPOSITORY_ERROR, ERROR_DESC_XDS_REPOSITORY_ERROR, hcid);
	}

	private RegistryErrorList createRegistryErrorList(final String errorCode, final String codeContext, final String hcid)
	{
		RegistryErrorList ret = new RegistryErrorList();
		ret.getRegistryError().add(createRegistryError(errorCode, codeContext, hcid));
		ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
		return ret;
	}

	private RegistryError createRegistryError(final String errorCode, final String codeContext, final String hcid)
	{
		RegistryError ret = new RegistryError();
		ret.setErrorCode(errorCode);
		ret.setCodeContext(codeContext);
		ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
		
		if(StringUtils.isNotBlank(hcid))
		{
			ret.setLocation(hcid);
		}
		else
		{
			ret.setLocation(getHomeFacility());
		}
		
		return ret;
	}

	private String getHomeFacility()
	{
		if(propertyLookup != null)
		{
			return propertyLookup.getProperty("HomeCommunityId");
		}

		return StringUtils.EMPTY;
	}
}
