package gov.va.med.nhin.adapter.docquery;

import gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType;
import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.eventcommon.AdhocQueryRequestEventType;
import gov.hhs.fha.nhinc.common.eventcommon.AdhocQueryRequestMessageType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayQueryRequestType;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.PolicyEngineTransformer;
import gov.va.med.nhin.adapter.errors.CreateErrorInterface;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.logging.CheckPolicy;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.logging.MaintLog;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.sensitiveInfo.SensitiveInfoManager;
import gov.va.med.nhin.adapter.sensitiveInfo.SensitiveInfoManagerLocal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.BindingType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AdhocQueryType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.IdentifiableType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueListType;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryErrorList;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocQueryA1Soap12",
            //wsdlLocation = "META-INF/wsdl/AdapterDocQueryA1Soap12.wsdl",
            portName = "AdapterDocQueryPortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocquery")
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@HandlerChain(file="SOAPHandlerChain.xml")
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AdapterDocQueryA1")
public class AdapterDocQueryA1 implements AdapterDocQueryPortTypeLocal
{
    private static final Logger logger = LoggerFactory.getLogger(AdapterDocQueryA1.class.getName());

    static private final String DOCQUERY_DOCENTRY_TYPE_PARAMETER = "$XDSDocumentEntryType";
    static private final String DOCQUERY_DOCENTRY_STATUS_PARAMETER = "$XDSDocumentEntryStatus";

    static private final String IHE_DOCUMENT_ENTRY_TYPE_STABLE_URN = "urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1";
    static private final String IHE_DOCUMENT_ENTRY_STATUS_APPROVED_URN = "urn:oasis:names:tc:ebxml-regrep:StatusType:Approved";
    static private final String IHE_DOCUMENT_ENTRY_STATUS_DEFERREDCREATION_URN = "urn:ihe:iti:2010:StatusType:DeferredCreation";

    static private final String IHE_DOCUMENT_QUERY_RESPONSE_SIZE_SLOT_NAME = "size";
    static private final String IHE_DOCUMENT_QUERY_RESPONSE_HASH_SLOT_NAME = "hash";
    static private final String IHE_DELAYED_DOCUMENT_ASSEMBLY_ZERO_BYTE_SHA1_HASH = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private AdapterDocQueryPortType docQuery;
    private AdapterPolicyEnginePortType policyEngine;
    private FacilityManager facilityManager;
    private CreateErrorInterface errorResponse;
    private SensitiveInfoManager sensitiveInfoBean;

    @EJB(beanInterface = CreateErrorInterface.class, beanName = "CreateResponseError")
    public void setErrorResponse(CreateErrorInterface errorResponse)
    {
        this.errorResponse = errorResponse;
    }

    @EJB(beanInterface = AdapterDocQueryPortTypeLocal.class, beanName = "DocQuery")
    public void setDocQuery(AdapterDocQueryPortType docQuery)
    {
        this.docQuery = docQuery;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setPolicyEngine(AdapterPolicyEnginePortType policyEngine)
    {
        this.policyEngine = policyEngine;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = SensitiveInfoManagerLocal.class, beanName = "SensitiveInfoBean")
    public void setSensitiveInfoBean(SensitiveInfoManager sensitiveInfoBean)
    {
        this.sensitiveInfoBean = sensitiveInfoBean;
    }

    public AdhocQueryResponse respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        String partnerCommunityId = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
				logger.debug("Entering Document Query Call  - The partner Homecommunity ID  is {} ", partnerCommunityId);

        AdhocQueryResponse ret;
        try {
            if (facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.ONBOARD)) {
                if (facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.IN_DQ)) {
                    if (checkPolicy(respondingGatewayCrossGatewayQueryRequest)) {
                        AdhocQueryRequest body = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
                        AdhocQueryType adhocQuery = body.getAdhocQuery();
                        List<SlotType1> slots = adhocQuery.getSlot();
                        Map<String, List<ValueList>> queryParams = getMapFromSlots(slots);

                        List<ValueList> documentEntryTypeList = queryParams.get(DOCQUERY_DOCENTRY_TYPE_PARAMETER);
                        if (documentEntryTypeList != null && documentEntryTypeList.size() > 0) {
                            if (documentEntryTypeList.size() > 1) {
                                // AND condition detected, documents can not
                                // both types
                                // simultaneously
                                MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_STATUS_ENTRY, logger);
                                ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
                                return ret;
                            }
                            else {
                                boolean stableDocumentRequested = false;
                                for (Value value : documentEntryTypeList.get(0)) {
                                    if (IHE_DOCUMENT_ENTRY_TYPE_STABLE_URN.equals(value.getValue().toString())) {
                                        stableDocumentRequested = true;
                                        break;
                                    }
                                }

                                if (!stableDocumentRequested) {
                                    ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
                                    MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_STABLE, logger);
                                    return ret;
                                }
                            }
                        }

                        // check the status values
                        // if Approved is present, add DeferredCreation to the
                        // list of
                        // status values
                        List<ValueList> documentEntryStatusList = queryParams.get(DOCQUERY_DOCENTRY_STATUS_PARAMETER);
                        if (documentEntryStatusList != null && documentEntryStatusList.size() > 0) {
                            if (documentEntryStatusList.size() > 1) {
                                // AND condition detected, documents can not
                                // both status
                                // values simultaneously
                                MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_STATUS_ENTRY, logger);
                                ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
                                return ret;
                            }
                            else {
                                HashSet<String> requestedStatusValues = new HashSet<String>();
                                boolean approvedStatusRequested = false;
                                boolean deferredCreationRequested = false;
                                for (Value value : documentEntryStatusList.get(0)) {
                                    requestedStatusValues.add(value.getValue().toString());
                                    if (IHE_DOCUMENT_ENTRY_STATUS_APPROVED_URN.equals(value.getValue().toString())) {
                                        approvedStatusRequested = true;
                                    }
                                    else if (IHE_DOCUMENT_ENTRY_STATUS_DEFERREDCREATION_URN.equals(value.getValue().toString())) {
                                        // while this is technically not
                                        // SUPPOSED to be
                                        // here, will all participants be
                                        // diligent about
                                        // compliance?
                                        deferredCreationRequested = true;
                                    }
                                }

                                if (!deferredCreationRequested) {
                                    if (approvedStatusRequested) {
                                        // add DeferredCreation to the Slot
                                        // list, so the
                                        // inner object will process correctly
                                        requestedStatusValues.add(IHE_DOCUMENT_ENTRY_STATUS_DEFERREDCREATION_URN);
                                    }
                                    else {
                                        MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_NON_APPROVED_ENTY, logger);
                                        ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
                                        return ret;
                                    }

                                    // regenerate the status Slot, for the inner
                                    // doQuery
                                    // obkects
                                    for (SlotType1 slot : slots) {
                                        if (DOCQUERY_DOCENTRY_STATUS_PARAMETER.equals(slot.getName())) {

                                            boolean firstValue = true;
                                            StringBuffer statusValueQueryParam = new StringBuffer();
                                            statusValueQueryParam.append("(");
                                            for (String requestStatusValue : requestedStatusValues) {
                                                if (!firstValue) {
                                                    statusValueQueryParam.append(",");
                                                }
                                                statusValueQueryParam.append("'");
                                                statusValueQueryParam.append(requestStatusValue);
                                                statusValueQueryParam.append("'");
                                                firstValue = false;
                                            }

                                            statusValueQueryParam.append(")");
                                            ValueListType statusValueList = new ValueListType();
                                            statusValueList.getValue().add(statusValueQueryParam.toString());
                                            slot.setValueList(statusValueList);
                                            break;
                                        }
                                    }

                                }
                            }
                        }
                        else {
                            // status is a REQUIRED parameter
                            logDocQueryRequestError(respondingGatewayCrossGatewayQueryRequest, "DocQuery status is a REQUIRED parameter", null);
                            ret = createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest);
                            MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_STATUS_ENTRY, logger);
                            return ret;
                        }

                        ret = docQuery.respondingGatewayCrossGatewayQuery(respondingGatewayCrossGatewayQueryRequest);

                        // spin through the return documents and update the
                        // metadata
                        RegistryObjectListType registryObjectList = ret.getRegistryObjectList();
                        if (registryObjectList != null) {

                            List<JAXBElement<? extends IdentifiableType>> identifiableRegistryObjects = registryObjectList.getIdentifiable();
                            for (JAXBElement<? extends IdentifiableType> identifiableRegistryObject : identifiableRegistryObjects) {

                                if (identifiableRegistryObject.getValue() instanceof ExtrinsicObjectType) {

                                    ExtrinsicObjectType extrinsicObject = (ExtrinsicObjectType) identifiableRegistryObject.getValue();

                                    // set the status to be Approved
                                    extrinsicObject.setStatus(IHE_DOCUMENT_ENTRY_STATUS_APPROVED_URN);
                                    List<SlotType1> objectSlots = extrinsicObject.getSlot();
                                    SlotType1 sizeSlot = null;
                                    Integer size = 0;
                                    SlotType1 hashSlot = null;
                                    for (SlotType1 objectSlot : objectSlots) {
                                        if (IHE_DOCUMENT_QUERY_RESPONSE_SIZE_SLOT_NAME.equals(objectSlot.getName())) {
                                            sizeSlot = objectSlot;
                                        }
                                        else if (IHE_DOCUMENT_QUERY_RESPONSE_HASH_SLOT_NAME.equals(objectSlot.getName())) {
                                            hashSlot = objectSlot;
                                        }
                                    }

                                    if (sizeSlot != null) {

                                        // convert the size
                                        List<String> sizeValues = sizeSlot.getValueList().getValue();
                                        String sizeValue = sizeValues.get(0);
                                        size = Integer.valueOf(sizeValue);
                                        if (size <= 0) {
                                            size = 0;
                                            sizeValues.clear();
                                            sizeValues.add(size.toString());
                                        }
                                    }
                                    else {

                                        // per Delayed DocumentAssembly
                                        // specification,
                                        // an ungenerated document size, MUST be
                                        // 0
                                        size = 0;
                                        sizeSlot = DocQuery.CreateSingleValueSlot(IHE_DOCUMENT_QUERY_RESPONSE_SIZE_SLOT_NAME, size.toString());
                                        objectSlots.add(sizeSlot);
                                    }

                                    if (hashSlot != null) {

                                        if (size == 0) {
                                            if (hashSlot != null && hashSlot.getValueList() != null) {
                                                List<String> hashValues = hashSlot.getValueList().getValue();
                                                hashValues.clear();
                                                hashValues.add(IHE_DELAYED_DOCUMENT_ASSEMBLY_ZERO_BYTE_SHA1_HASH);
                                            }
                                        }
                                    }
                                    else if (size == 0) {
                                        sizeSlot = DocQuery.CreateSingleValueSlot(IHE_DOCUMENT_QUERY_RESPONSE_HASH_SLOT_NAME, IHE_DELAYED_DOCUMENT_ASSEMBLY_ZERO_BYTE_SHA1_HASH);
                                        objectSlots.add(sizeSlot);
                                    }
                                    else {
                                        // unhandled scenario: backend
                                        // provides a
                                        // size without computing the hash

                                        logDocQueryRequestError(respondingGatewayCrossGatewayQueryRequest, "DocQuery backend did NOT compute hash for non-zero length document", null);
                                    }
                                }
                            }
                        }
                    }
                    else {
                        ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
                    }
                }
                else {
                    ret = errorResponse.createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_DISABLED);
                    MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_DISABLED, logger);
                }
            }
            else {
                MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_NOT_A_PARTNER, logger);
                ret = errorResponse.createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_NOT_A_PARTNER);
            }
        }
        catch (Throwable t) {
            logDocQueryRequestError(respondingGatewayCrossGatewayQueryRequest, t.getMessage(), t);
            ret = createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest);
            MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_UKNOWN, t.getMessage(), logger);
        }

        return ret;
    }

    private void logDocQueryRequestError(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest, String message, Throwable t)
    {
        String hcid;
        String hcidName;
        if (respondingGatewayCrossGatewayQueryRequest.getAssertion() != null && respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity() != null) {
            hcid = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
            hcidName = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getName();
        }
        else {
            hcid = "N/A";
            hcidName = "Not Available";
        }

        // CCR 177986
        logger.error("Error processing DocQuery from {} {} - {}", new Object[]{hcid, hcidName, message});

        if (t != null) {
            logger.error("Exception occurred while trying to process the request {}", t);
        }
    }

    private boolean checkPolicy(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        logger.debug("Entering checkPolicy <AdapterDocQuery (2011 Spec)> call {}");
        AdhocQueryRequestMessageType adhocQueryRequestMessage = new AdhocQueryRequestMessageType();
        adhocQueryRequestMessage.setAdhocQueryRequest(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest());
        adhocQueryRequestMessage.setAssertion(respondingGatewayCrossGatewayQueryRequest.getAssertion());

        AdhocQueryRequestEventType policyCheckReq = new AdhocQueryRequestEventType();
        policyCheckReq.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);
        policyCheckReq.setMessage(adhocQueryRequestMessage);

        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformAdhocQueryToCheckPolicy(policyCheckReq);

        CheckPolicyResponseType checkPolicyResponse = policyEngine.checkPolicy(checkPolicyRequest);
        sensitiveInfoBean.checkPolicyAndAddSlot(respondingGatewayCrossGatewayQueryRequest, checkPolicyResponse);
        return CheckPolicy.checkPolicy(checkPolicyRequest, checkPolicyResponse);
    }

    private AdhocQueryResponse createAdhocQueryResponseEmpty(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        AdhocQueryRequest fromAdhocQueryRequest = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success");
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setRegistryObjectList(new RegistryObjectListType());
        return ret;
    }

    private AdhocQueryResponse createAdhocQueryResponseError(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        AdhocQueryRequest fromAdhocQueryRequest = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        ret.setRegistryErrorList(createDefaultRegistryErrorList());
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setRegistryObjectList(new RegistryObjectListType());
        return ret;
    }

    private RegistryErrorList createDefaultRegistryErrorList()
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.getRegistryError().add(createDefaultRegistryError());
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createDefaultRegistryError()
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode("XDSRegistryError");
        ret.setCodeContext("Internal Registry/Repository Error");
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setLocation(getHomeFacility().getFullHomeCommunityId());
        return ret;
    }

    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }

    private Map<String, List<ValueList>> getMapFromSlots(List<SlotType1> slots)
    {
        HashMap<String, List<ValueList>> returnMap = new HashMap<String, List<ValueList>>();

        for (SlotType1 slot : slots) {
            if (gov.va.med.nhin.adapter.utils.NullChecker.isNotNullOrEmpty(slot.getName()) && gov.va.med.nhin.adapter.utils.NullChecker.isNotNullOrEmpty(slot.getValueList()) && gov.va.med.nhin.adapter.utils.NullChecker.isNotNullOrEmpty(slot.getValueList().getValue())) {
                List<ValueList> valueLists = returnMap.get(slot.getName());
                if (valueLists == null) {
                    valueLists = new ArrayList<ValueList>();
                    returnMap.put(slot.getName(), valueLists);
                }

                ValueListType slotValueList = slot.getValueList();
                ValueList valueList = new ValueList();
                for (String value : slotValueList.getValue()) {
                    QueryParamStringToValueList.parseParamFormattedString(valueList, value);
                }

                valueLists.add(valueList);
            }
        }

        return returnMap;
    }
}
